package com.edgec.browserbackend.browser.config;

import com.edgec.browserbackend.common.utils.BindHistoryToString;
import com.edgec.browserbackend.common.utils.StringToBindHistory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mongodb.core.aggregation.DateOperators;
import org.springframework.data.mongodb.core.convert.CustomConversions;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class MongoConfig {
    @Bean
    public CustomConversions customConversions() {
        List<Converter<?, ?>> converterList = new ArrayList<Converter<?, ?>>();
        converterList.add(new BindHistoryToString());
        converterList.add(new StringToBindHistory());
        return new CustomConversions(converterList);
    }
}
