package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.google.gson.internal.$Gson$Preconditions;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface IpResourceRepository extends MongoRepository<IpResource, String> {
    IpResource findByAddr(String addr);
    IpResource findByAddrAndIsDeleted(String addr, boolean isDeleted);
    IpResource findByIdAndIsDeleted(String id, boolean isDeleted);
    List<IpResource> findByIdInAndIsDeleted(List<String> ipIds, boolean isDeleted);
    Page<IpResource> findByIdInAndIsDeletedOrderByPurchasedTimeDesc(List<String> ipIds, boolean isDeleted, Pageable pageable);
    List<IpResource> findByOwnerAndIsDeletedAndShopIdIsNull(String owner, boolean isDeleted);
    List<IpResource> findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(String owner, int status, boolean isDeleted);
    List<IpResource> findByStatusAndIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);
    Page<IpResource> findByAddrLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(String addr, List<String> ipIds, boolean isDeleted, Pageable pageable);
    Page<IpResource> findByVendorLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(String vendor, List<String> ipIds, boolean isDeleted, Pageable pageable);
    Page<IpResource> findByRegionLikeAndIdInAndIsDeletedOrderByPurchasedTimeDesc(String region, List<String> ipIds, boolean isDeleted, Pageable pageable);

    List<IpResource> findByValidTimeBetween(long beginTime, long endTime);

    int countByStatusAndIdInAndIsDeleted(int status, List<String> ipIds, boolean isDeleted);
}
