package com.edgec.browserbackend.common.commons.error;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

import java.time.LocalDateTime;

@JsonSerialize(using = IntelligroupOauthExceptionSerializer.class)
public class IntelligroupOauthException extends OAuth2Exception {

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "dd-MM-yyyy hh:mm:ss")
    private LocalDateTime timestamp;
    private String message;
    private String debugMessage;
    private int errorCode;

    public IntelligroupOauthException(String message, String debugMessage, int errorCode ) {
        super(message);
        timestamp = LocalDateTime.now();
        this.message = message;
        this.debugMessage = debugMessage;
        this.errorCode = errorCode;
    }

    public LocalDateTime getTimestamp() {
        return timestamp;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public String getDebugMessage() {
        return debugMessage;
    }

    public int getErrorCode() {
        return errorCode;
    }

}