package com.edgec.browserbackend.common.utils;

import com.edgec.browserbackend.browser.domain.BindHistory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.WritingConverter;

@WritingConverter
public class BindHistoryToString implements Converter<BindHistory, String> {

    @Override
    public String convert(BindHistory bindHistory) {
        return  "{ shopName=" + '"' + bindHistory.getShopName() + '"' +
                ", ip=" + '"' + bindHistory.getIp() + '"' +
                ", platform=" + '"' + bindHistory.getPlatform() + '"' +
                ", unbindTime=" + '"' + bindHistory.getUnbindTime() + '"' +
                " }";
    }
}
