package com.edgec.browserbackend.common.utils;

import com.edgec.browserbackend.browser.domain.BindHistory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

import java.util.StringTokenizer;

@ReadingConverter
public class StringToBindHistory implements Converter<String, BindHistory> {
    @Override
    public BindHistory convert(String s) {
        s = s.substring(2, s.lastIndexOf("}"));
        StringTokenizer stringTokenizer = new StringTokenizer(s, ",");
        BindHistory bindHistory = new BindHistory();
        if (stringTokenizer.hasMoreTokens()) {
            String str = stringTokenizer.nextToken();
            bindHistory.setUnbindTime(s.substring(s.indexOf('"') + 1, s.lastIndexOf('"')));
            str = stringTokenizer.nextToken();
            bindHistory.setUnbindTime(s.substring(s.indexOf('"') + 1, s.lastIndexOf('"')));
            str = stringTokenizer.nextToken();
            bindHistory.setUnbindTime(s.substring(s.indexOf('"') + 1, s.lastIndexOf('"')));
            str = stringTokenizer.nextToken();
            bindHistory.setUnbindTime(s.substring(s.indexOf('"') + 1, s.lastIndexOf('"')));
        }
        return bindHistory;
    }
}
