package com.edgec.browserbackend.account.domain;

import com.edgec.browserbackend.browser.domain.IpSummary;
import com.edgec.browserbackend.browser.domain.ShopSummary;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AccountDto {

    private String name;

    private String password;

    private List<AccountDto> child;

    private Date lastSeen;

    private String email;

    private String fullname;

    private String companyName;

    private String jobTitle;

    private String phoneNumber;

    private boolean allowedToCreateSubUser;

    private int permission = -1;

    private int balance;

    private boolean isPrePaid = true;

    private String parent;

    private String token;

    private List<String> whiteList = new ArrayList<>();

    private ShopSummary shopSummary;

    private IpSummary ipSummary;

    private List<String> queryIpUrlList;

    private Promotion promotion;

    private int authorized;

    public AccountDto(){

    }

    public AccountDto(Account account) {
        this.setName(account.getName());
        this.setAllowedToCreateSubUser(account.isAllowedToCreateSubUser());
        this.setCompanyName(account.getCompanyName());
        this.setEmail(account.getEmail());
        this.setJobTitle(account.getJobTitle());
        this.setPhoneNumber(account.getPhoneNumber());
        this.setParent(account.getParent());
        this.setToken(account.getToken());
        this.setPermission(account.getPermission());
        this.setWhiteList(account.getWhiteList());
        this.setQueryIpUrlList(account.getQueryIpUrlList());
        if (account.getPromotion() != null)
            this.setPromotion(account.getPromotion());
        this.authorized = account.getAuthorized();
    }

    public boolean isPrePaid() {
        return isPrePaid;
    }

    public void setPrePaid(boolean prePaid) {
        isPrePaid = prePaid;
    }

    public int getBalance() {
        return balance;
    }

    public void setBalance(int balance) {
        this.balance = balance;
    }

    public int getPermission() {
        return permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public List<String> getWhiteList() {
        return whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<AccountDto> getChild() {
        return child;
    }

    public void setChild(List<AccountDto> child) {
        this.child = child;
    }

    public Date getLastSeen() {
        return lastSeen;
    }

    public void setLastSeen(Date lastSeen) {
        this.lastSeen = lastSeen;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullname() {
        return fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getJobTitle() {
        return jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean isAllowedToCreateSubUser() {
        return allowedToCreateSubUser;
    }

    public void setAllowedToCreateSubUser(boolean allowedToCreateSubUser) {
        this.allowedToCreateSubUser = allowedToCreateSubUser;
    }

    public String getParent() {
        return parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }


    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public ShopSummary getShopSummary() {
        return shopSummary;
    }

    public void setShopSummary(ShopSummary shopSummary) {
        this.shopSummary = shopSummary;
    }

    public IpSummary getIpSummary() {
        return ipSummary;
    }

    public void setIpSummary(IpSummary ipSummary) {
        this.ipSummary = ipSummary;
    }

    public List<String> getQueryIpUrlList() {
        return queryIpUrlList;
    }

    public void setQueryIpUrlList(List<String> queryIpUrlList) {
        this.queryIpUrlList = queryIpUrlList;
    }

    public Promotion getPromotion() {
        return promotion;
    }

    public void setPromotion(Promotion promotion) {
        this.promotion = promotion;
    }

    public int getAuthorized() {
        return authorized;
    }

    public void setAuthorized(int authorized) {
        this.authorized = authorized;
    }
}
