package com.edgec.browserbackend.account.repository;
import com.edgec.browserbackend.account.domain.UserLackMoney;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Update;

import java.util.List;

import static org.springframework.data.mongodb.core.query.Criteria.where;

public class UserLackMoneyRepositoryCustomImpl implements UserLackMoneyRepositoryCustom {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public void updateUserLackMoney(UserLackMoney userLackMoney) {
        Document doc = new Document();
        BasicQuery basicQuery = new BasicQuery(doc);
        basicQuery.addCriteria(where("_id").is(userLackMoney.getUsername()));
        Update update = new Update();
        update.set("lackMoney", userLackMoney.getLackMoney())
                .set("billIds", userLackMoney.getBillIds())
                .set("billsNum", userLackMoney.getBillsNum())
                .set("updateDate", userLackMoney.getUpdateDate());
        UpdateResult result = mongoTemplate.updateFirst(basicQuery, update, UserLackMoney.class);

    }

    @Override
    public List<UserLackMoney> findAllLack() {

        MatchOperation match = Aggregation.match(where("lackMoney").gt(0));
        AggregationResults<UserLackMoney> aggregation = mongoTemplate.aggregate(Aggregation.newAggregation(match), UserLackMoney.class, UserLackMoney.class);
        return aggregation.getMappedResults();
    }
}
