package com.edgec.browserbackend.account.service;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtils {

    private static final Logger log = LoggerFactory.getLogger(SmsUtils.class);

    private static final int TIME_OUT=10*60; //10minues

    /**
     * Generate and send the SMS one time password to user's phone with SMS.
     * @param phone
     */
    public static String sendSmsOTP(String phone) {
        String randomCode = createRandom(true,6);
        DefaultProfile profile = DefaultProfile.getProfile("default", "LTAIODPWRh6stFca", "0SBDR59HsquSDEj9CFXNt9njTs2cCv");
        IAcsClient client = new DefaultAcsClient(profile);

        CommonRequest request = new CommonRequest();
        //request.setProtocol(ProtocolType.HTTPS);
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("SignName", "防关联浏览器");
        request.putQueryParameter("PhoneNumbers", phone);
        request.putQueryParameter("TemplateCode", "SMS_185841618");
        request.putQueryParameter("TemplateParam", "{\"code\":\""+randomCode+"\"}");
        try {
            CommonResponse response = client.getCommonResponse(request);
            if (response.getHttpStatus() == 200 && response.getData().contains("OK")) {
                return randomCode;
            } else {
                log.error("fail to send sms {}", response.getData());
                throw new ClientRequestException(AccountErrorCode.OTPSENDFAILS, AccountErrorCode.OTPSENDFAILS.getReason());
            }
        } catch (ServerException e) {
            log.error("Sms sends failure",e);
            throw new ClientRequestException(AccountErrorCode.OTPSENDFAILS, AccountErrorCode.OTPSENDFAILS.getReason());
        } catch (ClientException e) {
            log.error("Sms sends failure",e);
            throw new ClientRequestException(AccountErrorCode.OTPSENDFAILS, AccountErrorCode.OTPSENDFAILS.getReason());
        }

    }

    public static String createRandom(boolean numberFlag, int length) {
        String retStr = "";
        String strTable = numberFlag ? "1234567890" : "1234567890abcdefghijkmnpqrstuvwxyz";
        int len = strTable.length();
        boolean bDone = true;
        do {
            retStr = "";
            int count = 0;
            for (int i = 0; i < length; i++) {
                double dblR = Math.random() * len;
                int intR = (int) Math.floor(dblR);
                char c = strTable.charAt(intR);
                if (('0' <= c) && (c <= '9')) {
                    count++;
                }
                retStr += strTable.charAt(intR);
            }
            if (count >= 2) {
                bDone = false;
            }
        } while (bDone);
        return retStr;
    }

}
