package com.edgec.browserbackend.browser.ErrorCode;

import com.edgec.browserbackend.common.commons.error.ErrorCode;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BrowserErrorCode implements ErrorCode {

    /* client errors */

    UNKNOWN(ErrorCode.COMMON_UNKNOWN, "unknown"),
    INFORMATIONNOTCOMPELETE(BROWSER_BASE + 100, "The information about shop does not complete"),
    SHOPNOTEXIST(BROWSER_BASE + 101, "The shop does not exist"),
    SHOP_BINDED(BROWSER_BASE + 102, "The shop has bind with ip"),

    IPNOTEXIST(BROWSER_BASE + 201, "The ip do not exist"),
    IPNOTBINDTOSHOP(BROWSER_BASE + 202, "The ip does not bind this shop."),

    GROUPNOTEXIST(BROWSER_BASE + 301, "The group does not exist"),

    IPTRANSACTIONNOTEXIST(BROWSER_BASE + 401, "The ipTransaction does not exist"),

    COMPANYAUTHORIZEEXIST(BROWSER_BASE + 501, "The authority exists"),
    COMPANYAUTHORIZENOTEXIST(BROWSER_BASE + 502, "The authority dose not exist");


    private final int code;
    private final String reason;

    private BrowserErrorCode(int value, String reasonPhrase) {
        this.code = value;
        this.reason = reasonPhrase;
    }

    @Override
    public int value() {
        return this.code;
    }

    @JsonValue
    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String toString() {
        return Integer.toString(this.code);
    }

    @Override
    public String getReason() {
        return reason;
    }
}
