package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.domain.PaymentMethod;
import com.edgec.browserbackend.account.domain.UserPayment;
import com.edgec.browserbackend.account.repository.UserPaymentRepository;
import com.edgec.browserbackend.account.service.PaymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;

@Component
public class PaymentTask {

    private static final Logger log = LoggerFactory.getLogger(PaymentTask.class);


    @Autowired
    private UserPaymentRepository userPaymentRepository;

    @Autowired
    private PaymentService paymentService;

    @Scheduled(fixedDelay = 60000)
    public void checkPayments() {
        long now = System.currentTimeMillis();
        Date date_5min = new Date(now - 5 * 60 * 1000);
        Date date_10min = new Date(now - 10 * 60 * 1000);
        List<UserPayment> unfinishedPayments = userPaymentRepository.findAllByPaymentDateBetweenAndSucceed(
                ZonedDateTime.ofInstant(date_10min.toInstant(), ZoneId.systemDefault())
                , ZonedDateTime.ofInstant(date_5min.toInstant(), ZoneId.systemDefault()), false);

        if (unfinishedPayments != null && unfinishedPayments.size() > 0) {

            unfinishedPayments.stream().forEach(payment -> {
                PaymentMethod paymentMethod = payment.getPaymentMethod();

                try {
                    if (PaymentMethod.WECHAT.equals(paymentMethod)) {
                        paymentService.wxCheckOrderStatus(payment.getTradeNo());
                    } else if (PaymentMethod.ALIPAY.equals(paymentMethod)) {
                        paymentService.aliCheckOrderStatus(payment.getTradeNo());
                    }
                } catch (Exception e) {
                    log.error("checkPayments", e);
                }
            });
        }
    }
}
