package com.edgec.browserbackend.common.utils;

import org.apache.commons.io.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class Trans {
    private final Logger logger = LoggerFactory.getLogger(Trans.class);

    /**
     * 以秒为单位
     */
    static int timeout = 10 * 1000;

    private static final String SPECIAL_HOST = "39.108.183.128";
    private static final int SPECIAL_PORT = 20008;

    private String host;
    private int port;

    private String username;
    private String password;

    public Trans(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.password = password;
        this.username = username;
    }

    public Trans(String username, String password) {
        this.host = SPECIAL_HOST;
        this.port = SPECIAL_PORT;
        this.password = password;
        this.username = username;
    }

    /**
     * 主入口方法
     *
     * @param args
     */
    public static void main(String[] args) {
        String url = "http://free.ipwhois.io/json/";
        Trans trans = new Trans("112.74.47.217", 20001, "fangguanlianbrowser", "5D753F36QKqIaA1");
        String rs = trans.get(url);
        System.out.println(rs);
    }

    /**
     * 向指定URL发送GET方法的请求
     */
    public String get(String url) {
        StringBuffer sb = new StringBuffer();
        HttpHost proxy = new HttpHost(host, port);
        // 设置认证
        CredentialsProvider provider = new BasicCredentialsProvider();

        provider.setCredentials(new AuthScope(proxy), new UsernamePasswordCredentials(username, password));
        //创建httpClient实例
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(provider).build();
        //创建httpGet实例
        HttpGet httpGet = new HttpGet(url);
        //设置代理IP，设置连接超时时间 、 设置 请求读取数据的超时时间 、 设置从connect Manager获取Connection超时时间、

        RequestConfig requestConfig = RequestConfig.custom()
                                                   .setProxy(proxy)
                                                   .setConnectTimeout(5000)
                                                   .setSocketTimeout(5000)
                                                   .setConnectionRequestTimeout(5000)
                                                   .build();
        httpGet.setConfig(requestConfig);

        //执行
        try {
            HttpResponse response = client.execute(httpGet);

            HttpEntity entry = response.getEntity();
            return EntityUtils.toString(entry, Charsets.UTF_8);
        } catch (ClientProtocolException e) {
            logger.error("ClientProtocolException");
            return "";
        } catch (IOException e) {
//            logger.error(e.getMessage(), e);
            logger.error("IOException");
            return "";
        } catch (Exception e) {
//            logger.error(e.getMessage(), e);
            logger.error("Exception");
            return "";
        } finally {
            httpGet.releaseConnection();
            try {
                client.close();
            } catch (IOException e) {
                logger.error("fail to close connection", e);
            }
        }
    }
}