package com.edgec.browserbackend.account.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.domain.*;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.repository.UserLackMoneyRepository;
import com.edgec.browserbackend.account.service.UserLackMoneyService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.commons.utils.SmsUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class UserLackMoneyServiceImpl implements UserLackMoneyService {

    @Autowired
    private AccountRepository repository;

    @Autowired
    private UserLackMoneyRepository userLackMoneyRepository;

    @Override
    public void updateLackMoney(List<UserPrePaidBilling> billings, boolean ifMessageRemind) {

        //用户名，欠费金额，账单Id，账单总数
        String username = billings.get(0).getUsername();
        float totalUnpaid = billings.stream().filter(x -> x.getStatus() == BillStatus.UNPAID)
                                    .map(x -> x.getTotal() - (x.getDeductionRecords() != null ? (x.getDeductionRecords().stream().collect(Collectors.summingDouble(
                                            DeductionRecord::getDeductionAmount
                                    )).longValue()) : (0))).collect(Collectors.summingDouble(Float::floatValue)).floatValue();
        List<String> ids = billings.stream().filter(x -> x.getStatus() == BillStatus.UNPAID).map(UserPrePaidBilling::getId).collect(Collectors.toList());
        int billsAmount = (int) billings.stream().filter(x -> x.getStatus() == BillStatus.UNPAID).count();

        UserLackMoney userLackMoney = new UserLackMoney(username, totalUnpaid, ids, billsAmount, new Date());

        UserLackMoney lackMoney = userLackMoneyRepository.findById(username).orElse(null);
        if (lackMoney == null) {
            userLackMoneyRepository.save(userLackMoney);
        } else {
            userLackMoneyRepository.updateUserLackMoney(userLackMoney);
        }

        //发送短信提醒
        if (totalUnpaid > 0 && ifMessageRemind) {
            Account account = repository.findByName(username).orElseThrow(() -> new ClientRequestException(AccountErrorCode.NAMENOTEXIST));
            String telephone = account.getPhoneNumber();
            JSONObject param = new JSONObject();
            param.put("billsamount", billsAmount);
            param.put("totalunpaid", totalUnpaid);
            SmsUtils.sendIpSms(telephone, SmsUtils.SmsTemplateCode.CLOUDAM_ARREARS, param);
        }
    }

    @Override
    public List<UserLackMoney> findAll() {
        return userLackMoneyRepository.findAllLack();
    }

}
