package com.edgec.browserbackend.auth.controller;

import com.edgec.browserbackend.auth.exception.AuthErrorCode;
import com.edgec.browserbackend.common.commons.error.ApiError;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.commons.error.InternalServerErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Deprecated
@ControllerAdvice
public class AuthErrorHandler extends ResponseEntityExceptionHandler {

    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals(status)) {
            request.setAttribute("javax.servlet.error.exception", ex, 0);
        }
        ApiError error = new ApiError(AuthErrorCode.OTHERS, "http request error");

        return new ResponseEntity(error, headers, status);
    }


    private ResponseEntity<Object> buildResponseEntity(ApiError apiError, HttpStatus status) {
        return new ResponseEntity<>(apiError, status);
    }

    @ExceptionHandler(IllegalArgumentException.class)
    public ResponseEntity<Object> processValidationError(IllegalArgumentException e) {
        log.debug("Returning HTTP 400 Bad Request", e);
        ApiError apiError = new ApiError(AuthErrorCode.OTHERS, e);
        return buildResponseEntity(apiError, HttpStatus.BAD_REQUEST);
    }


    @ExceptionHandler(ClientRequestException.class)
    public ResponseEntity<Object> processValidationError(ClientRequestException e) {
        log.debug("Returning HTTP 400 Client Request Eror", e);
        ApiError apiError = new ApiError(e.getErrorCode(), e);
        return buildResponseEntity(apiError, HttpStatus.BAD_REQUEST);
    }


    @ExceptionHandler(InternalServerErrorException.class)
    public ResponseEntity<Object> processValidationError(InternalServerErrorException e) {
        log.info("Returning HTTP 500 Internal Server Error", e);
        ApiError apiError = new ApiError(e.getErrorCode());
        return buildResponseEntity(apiError, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Override
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {

        ApiError apiError = new ApiError(AuthErrorCode.OTHERS, "Validation Failed");
        return buildResponseEntity(apiError, HttpStatus.BAD_REQUEST);
    }

}
