package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.dto.HistoryListRequestDto;
import com.edgec.browserbackend.browser.dto.LoginHistoryDto;
import com.edgec.browserbackend.browser.dto.OperationHistoryDto;
import com.edgec.browserbackend.browser.service.HistoryService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/history")
public class HistoryController {

    @Autowired
    HistoryService historyService;

    @RequestMapping(value = "/login/add", method = RequestMethod.POST)
    public ResultDto addLoginHistory(Principal principal, @RequestBody LoginHistoryDto loginHistoryDto) {
        ResultDto resultDto = new ResultDto();
        try {
            historyService.addLoginHistory(principal.getName(), loginHistoryDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @RequestMapping(value = "/operation/add", method = RequestMethod.POST)
    public ResultDto addOperationHistory(Principal principal, @RequestBody OperationHistoryDto operationHistoryDto) {
        ResultDto resultDto = new ResultDto();
        try {
            historyService.addOperationHistory(principal.getName(), operationHistoryDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @RequestMapping(value = "/login/list", method = RequestMethod.POST)
    public ResultDto getLoginHistories(Principal principal, @RequestBody HistoryListRequestDto historyListRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(historyService.getLoginHistories(principal.getName(), historyListRequestDto));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @RequestMapping(value = "/operation/list", method = RequestMethod.POST)
    public ResultDto getOperationHistories(Principal principal, @RequestBody HistoryListRequestDto historyListRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(historyService.getOperationHistories(principal.getName(), historyListRequestDto));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    private void dealClientRequestException(ResultDto resultDto, ClientRequestException e) {
        resultDto.setStatus(-1);
        Map<String, Object> statusInfo = new HashMap<>();
        statusInfo.put("code", e.getErrorCode());
        statusInfo.put("message", e.getMessage());
        resultDto.setStatusInfo(statusInfo);
    }
}
