package com.edgec.browserbackend.browser.domain;

import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.StringUtils;

@Getter
@Setter
@Document(collection = "groups")
public class Group {
    /**
     * 组 id
     */
    @Id
    private String id;

    /**
     * 组名
     */
    private String name;

    /**
     * 组创建者
     */
    private String owner;

    /**
     * 组详情
     */
    private String details;

    public void of(Group group) {
        if (!StringUtils.isEmpty(group.getId())) {
            this.setId(group.getId());
        }

        if (!StringUtils.isEmpty(group.getOwner())) {
            this.setOwner(group.getOwner());
        }

        if (!StringUtils.isEmpty(group.getDetails())) {
            this.setDetails(group.getDetails());
        }

        if (!StringUtils.isEmpty(group.getName())) {
            this.setName(group.getName());
        }
    }
}
