package com.edgec.browserbackend.browser.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Getter
@Setter
@NoArgsConstructor
@Document(collection = "ipresource")
@JsonIgnoreProperties(ignoreUnknown = true)
public class IpResource implements Serializable {

    @Id
    private String id;
    private String addr;
    private IpType ipType = IpType.VENDOR;
    private Vendor vendor;
    private String vendorCn;
    private String region;
    private String regionCn;
    //0:正常, 1:已过期, 2:即将过期, 3:正在分配, 4:未使用, 5:已失效, 6:未分配, 7:未缴费, 8:分配成功
    private int status;
    private List<String> port;
    private long purchasedTime;
    private long validTime;
    private String details;
    private List<BindHistory> bindHistory = new ArrayList<>();
    private boolean isDeleted;
    private String username;
    private String owner;
    private String userParent;
    private List<String> protocol;
    private String password;
    private double price;

    private boolean specialLine; //是否使用专线
    private boolean usingSpecialLine; //是否正在使用专线
    //专线数据
    private String proxyUsername; //专线的代理用户名
    private String proxyPassword; //专线的代理密码

    private String shopId;
    private List<String> shopIds = new ArrayList<>();
    private boolean bind;

    private boolean isLocked;
    private long lockTimestamp;
    private long healthLockTimestamp;

    private String unit;
    private int period;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpResource)) {
            return false;
        }
        IpResource that = (IpResource) o;
        return Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}



