package com.edgec.browserbackend.browser.dto;

import com.edgec.browserbackend.browser.domain.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IpResourceDto {
    private String id;
    private String addr;
    private Vendor vendor;
    private String region;
    //0:正常, 1:已过期, 2:即将过期, 3:正在分配, 4:未使用
    private int status;
    private List<String> port;
    private long purchasedTime;
    private long validTime;
    private String username;
    private String details;
    private String password;
    private List<String> protocol;
    List<ShopDto> bindShops;
    private ShopDto bindShop;
    private List<BindHistory> bindHistories;

    private boolean specialLine;
    //专线数据
    private String proxyUsername;
    private String proxyPassword;
    private List<String> proxyProtocol;
    private List<String> proxyPort;

    private String specialLineIp;

    public IpResourceDto() {
    }

    public IpResourceDto(IpResource ipResource, List<ShopDto> shopDtos, boolean useHistory) {
        this.id = ipResource.getId();
        this.addr = ipResource.getAddr();
        this.vendor = ipResource.getVendor();
        this.region = ipResource.getRegion();
        this.status = ipResource.getStatus();
        this.port = ipResource.getPort();
        this.purchasedTime = ipResource.getPurchasedTime();
        this.validTime = ipResource.getValidTime();
        this.username = ipResource.getUsername();
        this.details = ipResource.getDetails();
        this.password = ipResource.getPassword();
        this.protocol = ipResource.getProtocol();
        this.specialLine = ipResource.isSpecialLine();
        if (CollectionUtils.isNotEmpty(shopDtos)) {
            this.bindShops = shopDtos;
            this.bindShop = shopDtos.get(0);
        } else {
            this.bindShops = new ArrayList<>();
            this.bindShop = new ShopDto();
        }
        if (useHistory)
            this.bindHistories = ipResource.getBindHistory();
        else
            this.bindHistories = new ArrayList<>();

    }

    public IpResourceDto(IpResource ipResource, List<ShopDto> shopDtos, boolean useHistory, SpecialLine specialLine1) {
        this.id = ipResource.getId();
        this.addr = ipResource.getAddr();
        this.vendor = ipResource.getVendor();
        this.region = ipResource.getRegion();
        this.status = ipResource.getStatus();
        this.port = ipResource.getPort();
        this.purchasedTime = ipResource.getPurchasedTime();
        this.validTime = ipResource.getValidTime();
        this.username = ipResource.getUsername();
        this.details = ipResource.getDetails();
        this.password = ipResource.getPassword();
        this.protocol = ipResource.getProtocol();
        this.proxyUsername = ipResource.getProxyUsername();
        this.proxyPassword = ipResource.getProxyPassword();
        this.proxyPort = specialLine1.getProxyPort();
        this.proxyProtocol = specialLine1.getProxyProtocol();
        this.specialLine = ipResource.isSpecialLine();
        if (CollectionUtils.isNotEmpty(shopDtos)) {
            this.bindShops = shopDtos;
            this.bindShop = shopDtos.get(0);
        } else {
            this.bindShops = new ArrayList<>();
            this.bindShop = new ShopDto();
        }
        this.specialLineIp = specialLine1.getIp();
        if (useHistory)
            this.bindHistories = ipResource.getBindHistory();
        else
            this.bindHistories = new ArrayList<>();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getPort() {
        return port;
    }

    public void setPort(List<String> port) {
        this.port = port;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public long getValidTime() {
        return validTime;
    }

    public void setValidTime(long validTime) {
        this.validTime = validTime;
    }

    public long getPurchasedTime() {
        return purchasedTime;
    }

    public void setPurchasedTime(long purchasedTime) {
        this.purchasedTime = purchasedTime;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<ShopDto> getBindShops() {
        return bindShops;
    }

    public void setBindShops(List<ShopDto> bindShops) {
        this.bindShops = bindShops;
    }

    public List<String> getProtocol() {
        return protocol;
    }

    public void setProtocol(List<String> protocol) {
        this.protocol = protocol;
    }

    public List<BindHistory> getBindHistories() {
        return bindHistories;
    }

    public void setBindHistories(List<BindHistory> bindHistories) {
        this.bindHistories = bindHistories;
    }

    public String getProxyPassword() {
        return proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyUsername() {
        return proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public boolean isSpecialLine() {
        return specialLine;
    }

    public void setSpecialLine(boolean specialLine) {
        this.specialLine = specialLine;
    }

    public List<String> getProxyProtocol() {
        return proxyProtocol;
    }

    public void setProxyProtocol(List<String> proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getSpecialLineIp() {
        return specialLineIp;
    }

    public void setSpecialLineIp(String specialLineIp) {
        this.specialLineIp = specialLineIp;
    }

    public List<String> getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(List<String> proxyPort) {
        this.proxyPort = proxyPort;
    }

    public ShopDto getBindShop() {
        return bindShop;
    }

    public void setBindShop(ShopDto bindShop) {
        this.bindShop = bindShop;
    }
}
