package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.BindHistory;
import com.edgec.browserbackend.browser.domain.IpResource;

import java.util.List;

public interface IpResourceRepositoryCustom {

    boolean lockTask(IpResource ipResource);

    boolean unLockTask(String id);

    boolean healthLock(IpResource ipResource);

    boolean unLockHealth(String id);

    List<IpResource> sampleTasks(int status, long timestamp);

    List<IpResource> sampleTasks(List<Integer> status);

    List<IpResource> findIds();

    boolean addShopId(String ipId, String shopId);

    boolean deleteShopId(String ipId, String shopId, BindHistory bindHistory);

    boolean updateStatus(String id, int status);

    boolean updateBind(String id, boolean isbind);

    List<IpResource> findShopIdInList(List<String> shopIds, boolean isDeleted);

    List<IpResource> findShopIdInListAndStatus(List<String> shopIds, boolean isDeleted, int status);

    List<IpResource> findShopIdInListAndRegionLike(List<String> shopIds, boolean isDeleted, String region);
}
