package com.edgec.browserbackend.account.repository;


import com.edgec.browserbackend.account.domain.UserBilling;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

@Repository
public interface UserBillingRepository extends MongoRepository<UserBilling, String> {

    List<UserBilling> findByUsernameOrderByYearDescMonthDesc(String username);

    List<UserBilling> findByUsernameInAndYearAndMonthOrderByYearDescMonthDesc(Collection<String> names, int year, int month);

    List<UserBilling> findByUsername(String username);
}
