package com.edgec.browserbackend.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class AlipaySubmit {

    private final static Logger logger = LoggerFactory.getLogger(AlipaySubmit.class);

    /**
     * 获取AccessToken
     * @param sParaTemp
     * @return
     */
    public static  String buildRequest(Map sParaTemp){
        AlipayConfig alipayConfig = new VpsAlipayConfig();
        AlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfig.getAPPID(),
                alipayConfig.getAPP_PRIVATE_KEY(), "json", alipayConfig.getCHARSET(), alipayConfig.getALIPAY_PUBLIC_KEY(), "RSA2");
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setCode((String)sParaTemp.get("auth_code"));
        request.setGrantType("authorization_code");
        try {
            AlipaySystemOauthTokenResponse oauthTokenResponse = alipayClient.execute(request);
            logger.error(oauthTokenResponse.getAccessToken());
            return oauthTokenResponse.getAccessToken();
        } catch (AlipayApiException e) {
            //处理异常
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取用户信息
     * @param accessToken
     * @return
     */
    public static String get(String accessToken){
        AlipayConfig alipayConfig = new VpsAlipayConfig();
        AlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayConfig.getAPPID(),
                alipayConfig.getAPP_PRIVATE_KEY(), "json", alipayConfig.getCHARSET(), alipayConfig.getALIPAY_PUBLIC_KEY(), "RSA2");
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();

        try {
            AlipayUserInfoShareResponse userinfoShareResponse = alipayClient.execute(request, accessToken);
            return  userinfoShareResponse.getUserId();
        } catch (AlipayApiException e) {
            //处理异常
            e.printStackTrace();
        }
        return null;
    }

}