package com.edgec.browserbackend.common.utils;

import com.edgec.browserbackend.common.commons.utils.PriorityThreadPoolExecutor;
import com.edgec.browserbackend.common.commons.utils.UniquePriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.*;

public abstract class ThreadPoolUtils {

    private static final Logger log = LoggerFactory.getLogger(ThreadPoolUtils.class);

    private static final int SCHEDULER_POOL_COUNT = 50;


    public static final int MAX_WAITING_TASKS = 10;

    public static final BlockingQueue<Runnable> schedulerQueue = new UniquePriorityBlockingQueue<>(50);


    private static final int TASK_POOL_COUNT = 20;

    public static final ExecutorService buyIpTasksPool = Executors.newFixedThreadPool(TASK_POOL_COUNT, new ThreadFactory() {
        int count = 1;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "browser-buyIp-task-" + count++);
        }
    });


    private static final int TIME_SCHEDULER_POOL_COUNT = 20;

    public static final ScheduledExecutorService queryIpTasksPool = Executors.newScheduledThreadPool(TIME_SCHEDULER_POOL_COUNT, new ThreadFactory() {
        int count = 1;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "browser-queyrIp-task-" + count++);
        }
    });


    private static final int IPTRANSACTION_POOL_COUNT = 10;

    public static final ScheduledExecutorService queryIpTransactionPool = Executors.newScheduledThreadPool(IPTRANSACTION_POOL_COUNT, new ThreadFactory() {
        int count = 1;

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "browser-ipTransaction-task-" + count++);
        }
    });
}
