package com.edgec.browserbackend.browser.domain;

import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

@Document(collection = "groups")
public class Group {
    @Id
    private String id;
    private String name;
    private String owner;
    private String details;

    public void of(Group group){
        if (StringUtils.isNotBlank(group.getId()))
            this.setId(group.getId());
        if (StringUtils.isNotBlank(group.getOwner()))
            this.setOwner(group.getOwner());
        if (StringUtils.isNotBlank(group.getDetails()))
            this.setDetails(group.getDetails());
        if (StringUtils.isNotBlank(group.getName()))
            this.setName(group.getName());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }
}
