package com.edgec.browserbackend.browser.domain;

import com.edgec.browserbackend.browser.dto.LoginHistoryDto;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@Document(collection = "loginhistory")
public class LoginHistory {
    @Id
    private String id;
    private String username;
    private String nickname;
    private String loginIp;
    private String loginPlace;
    private long loginTime;
    private String administrator;

    public LoginHistory () {

    }

    public LoginHistory(LoginHistoryDto loginHistoryDto) {
        if (loginHistoryDto.getAccount() != null)
            this.username = loginHistoryDto.getAccount();
        if (loginHistoryDto.getNickname() != null)
            this.nickname = loginHistoryDto.getNickname();
        if (loginHistoryDto.getLoginIp() != null)
            this.loginIp = loginHistoryDto.getLoginIp();
        if (loginHistoryDto.getLoginPlace() != null)
            this.loginPlace = loginHistoryDto.getLoginPlace();
        if (loginHistoryDto.getLoginTime() != null) {
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime localDateTime = LocalDateTime.parse(loginHistoryDto.getLoginTime(), format);
            this.loginTime = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getLoginPlace() {
        return loginPlace;
    }

    public void setLoginPlace(String loginPlace) {
        this.loginPlace = loginPlace;
    }

    public String getLoginIp() {
        return loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(long loginTime) {
        this.loginTime = loginTime;
    }

    public String getAdministrator() {
        return administrator;
    }

    public void setAdministrator(String administrator) {
        this.administrator = administrator;
    }
}
