package com.edgec.browserbackend.browser.service;

import com.edgec.browserbackend.browser.domain.Shop;
import com.edgec.browserbackend.browser.domain.ShopSummary;
import com.edgec.browserbackend.browser.dto.ShopFilterDto;
import com.edgec.browserbackend.browser.dto.ShopPageResultDto;
import com.edgec.browserbackend.browser.dto.ShopRequestDto;
import com.edgec.browserbackend.browser.dto.ShopResultDto;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

public interface ShopService {

    String addShop(String useranme, ShopResultDto shopResultDto);

    List<String> addShops(String username, MultipartFile file) throws IOException;

    String updateShop(String username, ShopResultDto shopResultDto);

    void deleteShop(String username, String shopId);

    void transferShop(String username, String shopId, String groupId);

    void assignShops(String username, List<String> shopIds, List<String> users);

    ShopPageResultDto getShopList(String username, String groupId, int page, int amount, ShopFilterDto shopFilterDto);

    ShopSummary getShopSummary(String username);

    List<String> getShopUsers(String username, String shopId);

    List<String> getBatchShopUsers(String username, List<String> shopIds);
}
