package com.edgec.browserbackend.browser.controller;

import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.domain.WinHistory;
import com.edgec.browserbackend.browser.dto.HistoryListRequestDto;
import com.edgec.browserbackend.browser.dto.LoginHistoryDto;
import com.edgec.browserbackend.browser.dto.OperationHistoryDto;
import com.edgec.browserbackend.browser.service.HistoryService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/history")
public class HistoryController {

    private final Logger log = LoggerFactory.getLogger(HistoryController.class);

    @Autowired
    HistoryService historyService;

    @RequestMapping(value = "/login/add", method = RequestMethod.POST)
    public ResultDto addLoginHistory(Principal principal, @RequestBody LoginHistoryDto loginHistoryDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【addLoginHistory】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            historyService.addLoginHistory(principal.getName(), loginHistoryDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @RequestMapping(value = "/operation/add", method = RequestMethod.POST)
    public ResultDto addOperationHistory(Principal principal, @RequestBody OperationHistoryDto operationHistoryDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【addOperationHistory】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            historyService.addOperationHistory(principal.getName(), operationHistoryDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @RequestMapping(value = "/login/list", method = RequestMethod.POST)
    public ResultDto getLoginHistories(Principal principal, @RequestBody HistoryListRequestDto historyListRequestDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【getLoginHistories】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            resultDto.setData(historyService.getLoginHistories(principal.getName(), historyListRequestDto));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @RequestMapping(value = "/operation/list", method = RequestMethod.POST)
    public ResultDto getOperationHistories(Principal principal, @RequestBody HistoryListRequestDto historyListRequestDto) {
        ResultDto resultDto = new ResultDto();
        String logs = "【getOperationHistories】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            resultDto.setData(historyService.getOperationHistories(principal.getName(), historyListRequestDto));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
        return resultDto;
    }

    @PostMapping("/url/add")
    public void addWinlog(Principal principal, @RequestBody String urlRecord) {
        ResultDto resultDto = new ResultDto();
        String logs = "【addWinlog】 ";
        log.info("{}, params : {}", logs, principal.getName());
        try {
            WinHistory winHistory = new WinHistory(Instant.now().toEpochMilli(), urlRecord);
            historyService.addBrowserWinLog(principal.getName(), winHistory);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            log.error("{}, Exception : {}", logs, e.getMessage(), e);
            dealClientRequestException(resultDto, e);
        }
    }

    private void dealClientRequestException(ResultDto resultDto, ClientRequestException e) {
        resultDto.setStatus(-1);
        Map<String, Object> statusInfo = new HashMap<>();
        statusInfo.put("code", e.getErrorCode());
        statusInfo.put("message", e.getMessage());
        resultDto.setStatusInfo(statusInfo);
    }
}
