package com.edgec.browserbackend.common.utils;

import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;

/**
 * @author xuxin
 * @date 2020/8/17 11:27
 * @description
 */
@Slf4j
public class BeanUtils {

    /**
     * 赋值给同类对象
     * 将origin属性注入到destination中
     *
     * @param origin      原始对象
     * @param destination 目标对象
     * @param <T>         泛型
     */
    public static <T> void mergeObject(T origin, T destination) {
        if (origin == null || destination == null) {
            return;
        }

        if (!origin.getClass().equals(destination.getClass())) {
            return;
        }

        Field[] fields = origin.getClass().getDeclaredFields();

        for (Field field : fields) {
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(origin);

                if (value != null && !"".equals(value)) {
                    field.set(destination, value);
                }
            } catch (IllegalAccessException e) {
                log.error("同类对象赋值失败", e);
            }
            field.setAccessible(false);
        }

    }
}
