package com.edgec.browserbackend.account.service;

import com.edgec.browserbackend.account.domain.*;
import com.edgec.browserbackend.account.dto.*;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.io.File;
import java.util.List;

public interface AdministratorService {

    Administrator createAdministrator(Administrator administrator);

    Administrator updateAdministrator(String name, String string);

    List<Administrator> getAllAdministrator();

    void deleteAdministrator(String name);

    Account getAccountByName(String target);

    Account getAccountByPhoneNumber(String target);

    Account getAccountByEmail(String target);

    BillQueryResultDto getUserBillingByName(String name);

    Account unLockLockedAccount(String name, Account account);

    Account lockAbnormalAccount(String name, Account account);

    Page<Account> searchAllUserPage(Pageable pageable);

    Page<UserPrePaidBilling> searchAllUserBillingPage(int page, int year1, int month1, int year2, int month2);

    Page<Account> searchCreateAccountBetween(Pageable pageable, String strDate1, String strDate2, int isAuthorized);

    List<UserPrePaidBilling> getServiceFeeOwedUserInfo();

    List<CompanyEarningsDto> getCompanyEarningDetail(String stringdate);

    boolean getUserLockState(String name);

    void deleteUser(String username);

    UserBalance findUserBalance(String username);

    //迁移userbilling到userprepaidbilling
    boolean userbillingTransfer();

    void addPromotionCode(String username, String promotionCode);

    IpCountQueryResultDto queyrIpCount(String username);

    PromotionQueryResultDto queryPromotion(Pageable pageable, String username, String promotionCode, String strDate1, String strDate2);

    PromotionInfoDto countPromotionInfos(String username, String promotionCode, String beginDate, String endDate);

    Page<AccountPromotionDto> pagePromotionInfos(Pageable pageable, String username, String promotionCode, String beginDate, String endDate);

    void addWhiteList(String website);

    void addUserWhiteList(String username, String website);

    File getProxyConfig();

    Page<UserUsedDto> getAllUserUsed(Pageable pageable);

    Long convertToDistributor(String id, boolean tag);

    List<String> getUsernameIpList(String owner);

    List<String> ipMigration(String owner, String newOwner, String ips);

    void setNotice(Notice notice);

    NoticeDto getNotice();

    void delNotice();
}
