package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.LoginHistory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

public interface LoginHistoryRepository extends MongoRepository<LoginHistory, String> {
    LoginHistory findFirstByUsername(String username);

    Page<LoginHistory> findByAdministratorAndLoginTimeGreaterThanOrderByLoginTimeDesc(String administrator, long time, Pageable pageable);

    Page<LoginHistory> findByUsernameAndLoginTimeGreaterThanOrderByLoginTimeDesc(String username, long time, Pageable pageable);

    int countByUsername(String username);
}
