package com.edgec.browserbackend.browser.service;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.domain.IpOptions;
import com.edgec.browserbackend.browser.domain.IpSummary;
import com.edgec.browserbackend.browser.domain.PlatformOptions;
import com.edgec.browserbackend.browser.domain.ReceptionPlatformOptions;
import com.edgec.browserbackend.browser.dto.*;

import java.security.Principal;
import java.util.List;

public interface IpResourceService {

    List<String> buyIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception;

    IpOperationResultDto renewIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception;

    IpOperationResultDto deleteIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception;

    IpOperationResultDto deleteExpiredIp(String username, IpResourceRequestDto ipResourceRequestDto);

    IpPageResultDto getIpList(String username, int groupType, int page, int amount, IpFilterDto ipFilterDto);

    void setIpOptions();

    IpOptions getIpOptions();

    List<PlatformOptions> getPlatformOptions();

    IpSummary getIpSummary(String username);

    void updateIp(String username, IpResourceUpdateDto ipResourceUpdateDto);

    boolean queryIpExist(String username, IpResourceUpdateDto ipResourceUpdateDto);

    IpResourceDto queryIp(String username, IpResourceRequestDto ipResourceRequestDto);

    void setSpecialLine();

    void releaseDeletedIp();

    void transferBindShops();

    /**
     * 更换platformOptions地址
     *
     * @param principal 校验是否是管理员
     * @param platform 平台
     * @param subPlatform 平台站点
     * @param url url
     * @return boolean
     */
    boolean updatePlatformOptions(Principal principal, String platform, String subPlatform, String url);

    List<ReceptionPlatformOptions> getReceptionPlatformOptions();

    String getShop32Secret(String shopId);

    void saveShopSecret(String shopId, String sercret);

    Integer queryInventory(String name, IpResourceRequestDto ipResourceRequestDto);
}
