package com.edgec.browserbackend.browser.task;

import com.edgec.browserbackend.account.domain.QueryIpUrlList;
import com.edgec.browserbackend.account.repository.QueryIpUrlListRepository;
import com.edgec.browserbackend.browser.domain.GlobalField;
import com.edgec.browserbackend.browser.domain.IpResource;
import com.edgec.browserbackend.browser.repository.GlobalFieldRepository;
import com.edgec.browserbackend.browser.repository.IpResourceRepository;
import com.edgec.browserbackend.common.utils.Trans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author xuxin
 * @date 2020/8/3 14:29
 * @description
 */
@Component
public class SpecialLineCheckTask {
    private static final Logger log = LoggerFactory.getLogger(SpecialLineCheckTask.class);

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Autowired
    private QueryIpUrlListRepository queryIpUrlListRepository;

    @Autowired
    private GlobalFieldRepository globalFieldRepository;


    //@Scheduled(cron = "0 0/5 * * * ?")
    public void healthCheck() {
        // 1. 随机获取符合条件的 20 个 ip
        List<IpResource> ipResourceList = ipResourceRepository.specialLineCheckTask();

        // 2. 对获取的ip进行检查
        int[] arr = getCheckArray(ipResourceList);
        int finalSuccess = arr[0];
        int finalFail = arr[1];

        GlobalField globalField = getGlobalField();

        // 3. 获取 specialLine 的状态，并判断是否需要更新数据库状态
        String specialLineState = null;
        if ("on".equals(globalField.getSpecialLineState())) {
            specialLineState = finalFail == ipResourceList.size() ? "off" : null;
        }
        if ("off".equals(globalField.getSpecialLineState())) {
            specialLineState = finalSuccess > 1 ? "on" : null;
        }

        if (!StringUtils.isEmpty(specialLineState)) {
            globalField.setSpecialLineState(specialLineState);
            globalFieldRepository.save(globalField);
        }
    }

    private int[] getCheckArray(List<IpResource> ipResourceList) {
        List<QueryIpUrlList> queryIpUrlLists = queryIpUrlListRepository.findAll();
        int finalSuccess = 0;
        int finalFail = 0;
        for (IpResource ipResource : ipResourceList) {
            int success = 0;
            for (QueryIpUrlList queryIpUrlList : queryIpUrlLists) {
                Trans trans = new Trans(ipResource.getProxyUsername(), ipResource.getProxyPassword());
                String result = trans.get(queryIpUrlList.getUrl());
                if (result.contains(ipResource.getAddr())) {
                    success++;
                    break;
                }
            }

            if (success == 0) {
                finalFail++;
            }
            if (success == 1) {
                finalSuccess++;
            }
            // 用于性能优化
            if (finalSuccess == 2) {
                break;
            }
        }

        int[] arr = {finalSuccess, finalFail};
        return arr;
    }

    private GlobalField getGlobalField() {
        List<GlobalField> globalFieldList = globalFieldRepository.findAll();
        GlobalField globalField = null;
        if (globalFieldList.isEmpty()) {
            GlobalField g = new GlobalField();
            g.setSpecialLineState("on");
            globalField = globalFieldRepository.save(g);
        } else {
            globalField = globalFieldList.get(0);
        }
        return globalField;
    }


}
