package com.edgec.browserbackend.common.client;

import com.alibaba.fastjson.JSON;
import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.browser.domain.CloudPlatformConfig;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.Aes;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.cvm.v20170312.CvmClient;
import com.tencentcloudapi.cvm.v20170312.models.DescribeInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.DescribeInstancesResponse;
import com.tencentcloudapi.cvm.v20170312.models.DescribeZonesRequest;
import com.tencentcloudapi.cvm.v20170312.models.DescribeZonesResponse;
import com.tencentcloudapi.cvm.v20170312.models.InstanceChargePrepaid;
import com.tencentcloudapi.cvm.v20170312.models.LaunchTemplate;
import com.tencentcloudapi.cvm.v20170312.models.LoginSettings;
import com.tencentcloudapi.cvm.v20170312.models.ModifyInstancesChargeTypeRequest;
import com.tencentcloudapi.cvm.v20170312.models.ModifyInstancesChargeTypeResponse;
import com.tencentcloudapi.cvm.v20170312.models.Placement;
import com.tencentcloudapi.cvm.v20170312.models.RenewInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.RenewInstancesResponse;
import com.tencentcloudapi.cvm.v20170312.models.RunInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.RunInstancesResponse;
import com.tencentcloudapi.cvm.v20170312.models.TerminateInstancesRequest;
import com.tencentcloudapi.cvm.v20170312.models.TerminateInstancesResponse;
import com.tencentcloudapi.cvm.v20170312.models.ZoneInfo;
import com.tencentcloudapi.lighthouse.v20200324.LighthouseClient;
import com.tencentcloudapi.lighthouse.v20200324.models.Command;
import com.tencentcloudapi.lighthouse.v20200324.models.CreateInstancesRequest;
import com.tencentcloudapi.lighthouse.v20200324.models.CreateInstancesResponse;
import com.tencentcloudapi.lighthouse.v20200324.models.DockerContainerConfiguration;
import com.tencentcloudapi.lighthouse.v20200324.models.LoginConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * @Description //腾讯云ECS相关api
 * @Date 2024/9/2 14:40
 * @Author SN150021
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class TenCentEcsClient {

    //SecretId
    private static String getSecretId() {
        return "AKIDwoaIn1KbnrlT4Vq6NbkmfMrYC0oRs7A1";
    }

    //SecretKey
    private static String getSecretKey() {
        return "mLoCPQZinhmlZBboDXzKUTGtO3d2EJFI";
    }

    //脚本userData
    private static String getUserData() {
        return "#!/bin/sh\n"
            + "echo \"users %s:CL:%s\n"
            + "allow %s  *\n"
            + "auth strong\n"
            + "proxy -p8880\n"
            + "proxy -p8881 -a\n"
            + "socks -p8882\n"
            + "flush\" | tee /etc/3proxy.cfg\n"
            + "systemctl restart 3proxy";
    }


    private static CvmClient createClient(String regionId) {
        Credential cred = new Credential(getSecretId(), getSecretKey());
        // 实例化一个http选项，可选的，没有特殊需求可以跳过
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint("cvm.tencentcloudapi.com");
        // 实例化一个client选项，可选的，没有特殊需求可以跳过
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        // 实例化要请求产品的client对象,clientProfile是可选的
        return new CvmClient(cred, regionId, clientProfile);
    }

    private static LighthouseClient createLightHouseClient(String regionId) {
        Credential cred = new Credential(getSecretId(), getSecretKey());
        // 实例化一个http选项，可选的，没有特殊需求可以跳过
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint("lighthouse.tencentcloudapi.com");
        // 实例化一个client选项，可选的，没有特殊需求可以跳过
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        // 实例化要请求产品的client对象,clientProfile是可选的
        return new LighthouseClient(cred, regionId, clientProfile);
    }

    /**
     * 创建并运行实例
     */
    public static RunInstancesResponse runInstances(String owner,String username, String password, CloudPlatformConfig config) {
        CvmClient cvmClient = createClient(config.getRegionId());
        RunInstancesResponse runInstancesResponse = null;
        String userData = String.format(getUserData(), username, password, username);
        try {
            RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
            runInstancesRequest.setUserData(Aes.base64Encode(userData.getBytes()));
            LaunchTemplate launchTemplate = new LaunchTemplate();
            launchTemplate.setLaunchTemplateId(config.getTemplateId());
            launchTemplate.setLaunchTemplateVersion(config.getRegionId().equals("ap-beijing") ? 2L : 1L);
            runInstancesRequest.setLaunchTemplate(launchTemplate);
            LoginSettings loginSettings = new LoginSettings();
            loginSettings.setKeyIds(Collections.singletonList("skey-j9n2x0pl").toArray(new String[0]));
            runInstancesRequest.setLoginSettings(loginSettings);
            log.info("调用TenCentEcs创建并运行实例，入参：owner:{},regionId:{}, request{}", owner, config.getRegionId(), JSON.toJSON(runInstancesRequest));
            runInstancesResponse = cvmClient.RunInstances(runInstancesRequest);
            log.info("调用TenCentEcs创建并运行实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(runInstancesResponse));
        } catch (Exception e) {
            log.error("fail to tenCentEcs runInstances {}", e.getMessage());
        }
        return runInstancesResponse;
    }

    /**
     * 查询单个实例
     */
    public static DescribeInstancesResponse getDescribeInstances(String owner, String instanceId,
        String regionId) {
        CvmClient cvmClient = createClient(regionId);
        DescribeInstancesResponse describeInstancesResponse = null;
        try {
            DescribeInstancesRequest req = new DescribeInstancesRequest();
            String[] instanceIds = {""+ instanceId + ""};
            req.setInstanceIds(instanceIds);
            log.info("调用TenCentEcs查询单个实例，入参：owner:{},regionId:{},instanceId:{}",
                owner, regionId, instanceId);
            describeInstancesResponse = cvmClient.DescribeInstances(req);
            log.info("调用TenCentEcs查询单个实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(describeInstancesResponse));
        } catch (Exception e) {
            log.error("fail to TenCentEcs getDescribeInstances {}", e.getMessage());
        }
        return describeInstancesResponse;
    }

    /**
     * 删除ECS（退还实列)
     */
    public static TerminateInstancesResponse deleteInstance(String owner, String instanceId, String regionId) {
        CvmClient cvmClient = createClient(regionId);
        TerminateInstancesResponse response = null;
        try {
            TerminateInstancesRequest req = new TerminateInstancesRequest();
            String[] instanceIds = {""+ instanceId + ""};
            req.setInstanceIds(instanceIds);
            log.info("调用TenCentEcs删除ECS实例，入参：owner:{},instanceId:{},regionId{}",
                owner, instanceId, regionId);
            response = cvmClient.TerminateInstances(req);
            log.info("调用TenCentEcs删除ECS实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(response));
        } catch (Exception e) {
            log.error("fail to TenCentEcs deleteInstance {}", e.getMessage());
        }
        return response;
    }

    /**
     * 将按量改为包年包月
     */
    public static ModifyInstancesChargeTypeResponse modifyInstanceChargeType(String owner, int period, String regionId, String instanceId) {
        CvmClient cvmClient = createClient(regionId);
        ModifyInstancesChargeTypeResponse response = null;
        try {
            String[] instanceIds = {""+ instanceId + ""};
            ModifyInstancesChargeTypeRequest req = new ModifyInstancesChargeTypeRequest();
            req.setInstanceIds(instanceIds);

            req.setInstanceChargeType("PREPAID");
            InstanceChargePrepaid instanceChargePrepaid1 = new InstanceChargePrepaid();
            instanceChargePrepaid1.setPeriod((long) period);
            req.setInstanceChargePrepaid(instanceChargePrepaid1);
            log.info(
                "调用TenCentEcss将实例由量改为包年包月，入参：owner:{},regionId:{},period:{}, instanceId{}",
                owner, regionId, period, instanceId);
            response = cvmClient.ModifyInstancesChargeType(req);
            log.info("调用TenCentEcss将实例由量改为包年包月，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(response));
        } catch (Exception e) {
            log.error("fail to TenCentEcss modifyInstanceChargeType {}", e.getMessage());
        }
        return response;
    }

    /**
     * 续费实例
     */
    public static RenewInstancesResponse renewInstance(String owner, String regionId, String instanceId,
        Integer period){
        CvmClient cvmClient = createClient(regionId);
        RenewInstancesResponse response = null;
        try {
            RenewInstancesRequest req = new RenewInstancesRequest();
            String[] instanceIds = {""+ instanceId + ""};
            req.setInstanceIds(instanceIds);

            InstanceChargePrepaid instanceChargePrepaid1 = new InstanceChargePrepaid();
            instanceChargePrepaid1.setPeriod((long)period);
            req.setInstanceChargePrepaid(instanceChargePrepaid1);

            log.info("调用TenCentEcs续费实例，入参：owner:{},regionId:{},instanceId:{},period:{}", owner, regionId, instanceId, period);
            response = cvmClient.RenewInstances(req);
            log.info("调用TenCentEcs续费实例，响应参数:owner:{},response:{}", owner, JSON.toJSON(response));
        } catch (Exception e) {
            log.error("fail to TenCentEcs renewInstance {}", e.getMessage());
        }
        return response;
    }

    /**
     * 创建轻量级应用服务器
     */
    public static CreateInstancesResponse createInstances(String owner, String username,
        String password, CloudPlatformConfig config) {
        LighthouseClient cvmClient = createLightHouseClient(config.getRegionId());
        CreateInstancesResponse createInstancesResponse = null;
        String userData = String.format(getUserData(), username, password, username);
        try {

            // 实例化一个请求对象,每个接口都会对应一个request对象
            CreateInstancesRequest req = new CreateInstancesRequest();
            //TODO 暂时写死
            req.setBundleId("bundle_starter_nmc_lin_med2_01");
            req.setBlueprintId(config.getImageId());
            com.tencentcloudapi.lighthouse.v20200324.models.InstanceChargePrepaid instanceChargePrepaid =
                new com.tencentcloudapi.lighthouse.v20200324.models.InstanceChargePrepaid();
            instanceChargePrepaid.setPeriod(1L);
            req.setInstanceChargePrepaid(instanceChargePrepaid);
            LoginConfiguration loginSettings = new LoginConfiguration();
            loginSettings.setKeyIds(
                Collections.singletonList(config.getKeyId()).toArray(new String[0]));
            req.setLoginConfiguration(loginSettings);
            Command command = new Command();
            command.setContent(Aes.base64Encode(userData.getBytes()));
            req.setInitCommand(command);
            //TODO 暂时写死
            req.setFirewallTemplateId("lhft-46ceryhz");
            // 返回的resp是一个CreateInstancesResponse的实例，与请求对象对应
            log.info("调用TenCentEcs创建并运行轻量级实例，入参：owner:{},regionId:{}, request{}",
                owner, config.getRegionId(), JSON.toJSON(req));
            createInstancesResponse = cvmClient.CreateInstances(req);
            log.info("调用TenCentEcs创建并运行轻量级实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(createInstancesResponse));

        } catch (Exception e) {
            log.error("fail to tenCentEcs createInstances {}", e.getMessage());
        }
        return createInstancesResponse;
    }
    /**
     * 查询轻量级应用服务器
     */
    public static com.tencentcloudapi.lighthouse.v20200324.models.DescribeInstancesResponse getDescribeInstancesLight(
        String owner,
        String instanceId, String regionId) {
        LighthouseClient cvmClient = createLightHouseClient(regionId);

        // 返回的resp是一个DescribeInstancesResponse的实例，与请求对象对应
        com.tencentcloudapi.lighthouse.v20200324.models.DescribeInstancesResponse describeInstancesResponse = null;
        try {
            com.tencentcloudapi.lighthouse.v20200324.models.DescribeInstancesRequest req =
                new com.tencentcloudapi.lighthouse.v20200324.models.DescribeInstancesRequest();
            String[] instanceIds = {"" + instanceId + ""};
            req.setInstanceIds(instanceIds);
            log.info("调用TenCentEcs查询单个轻量级实例，入参：owner:{},regionId:{},instanceId:{}",
                owner, regionId, instanceId);
            describeInstancesResponse = cvmClient.DescribeInstances(req);
            log.info("调用TenCentEcs查询单个轻量级实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(describeInstancesResponse));
        } catch (Exception e) {
            log.error("fail to TenCentEcs getDescribeInstancesLight {}", e.getMessage());
        }
        return describeInstancesResponse;
    }

    /**
     * 续费轻量级实例
     */
    public static com.tencentcloudapi.lighthouse.v20200324.models.RenewInstancesResponse renewInstanceLight(String owner, String regionId, String instanceId,
                                                       Integer period){
        LighthouseClient cvmClient = createLightHouseClient(regionId);
        com.tencentcloudapi.lighthouse.v20200324.models.RenewInstancesResponse response = null;
        try {
            com.tencentcloudapi.lighthouse.v20200324.models.RenewInstancesRequest req =
                    new com.tencentcloudapi.lighthouse.v20200324.models.RenewInstancesRequest();
            String[] instanceIds = {""+ instanceId + ""};
            req.setInstanceIds(instanceIds);

            com.tencentcloudapi.lighthouse.v20200324.models.InstanceChargePrepaid instanceChargePrepaid1 = new com.tencentcloudapi.lighthouse.v20200324.models.InstanceChargePrepaid();
            instanceChargePrepaid1.setPeriod((long)period);
            req.setInstanceChargePrepaid(instanceChargePrepaid1);

            log.info("调用TenCentEcs续费轻量级实例，入参：owner:{},regionId:{},instanceId:{},period:{}", owner, regionId, instanceId, period);
            response = cvmClient.RenewInstances(req);
            log.info("调用TenCentEcs续费轻量级实例，响应参数:owner:{},response:{}", owner, JSON.toJSON(response));
        } catch (Exception e) {
            log.error("fail to TenCentEcs renewInstance {}", e.getMessage());
        }
        return response;
    }


}
