package com.edgec.browserbackend.common.client.ipvClient;

import com.alibaba.fastjson.JSON;
import com.edgec.browserbackend.browser.domain.CloudPlatformConfig;
import com.edgec.browserbackend.common.client.ipvClient.dto.*;
import com.edgec.browserbackend.common.client.ipvClient.utils.AESCBC;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
@Slf4j
public class IpvClient {
    private static final String VERSION = "v2";
    private static final String GET_APP_INFO_URI = "/api/open/app/info/" + VERSION;
    private static final String GET_PRODUCT_STOCK_URI = "/api/open/app/product/query/" + VERSION;
    private static final String CREATE_USER_URI = "/api/open/app/user/" + VERSION;
    private static final String CREATE_PROXY_USER_URI = "/api/open/app/proxy/user/" + VERSION;
    private static final String USER_AUTH_URI = "/api/open/app/userAuth/" + VERSION;
    private static final String DRAW_BY_PWD_URI = "/api/open/app/proxy/draw/pwd/" + VERSION;
    private static final String GET_ORDER_URI = "/api/open/app/order/" + VERSION;
    private static final String GET_INSTANCE_URI = "/api/open/app/instance/" + VERSION;
    private static final String GET_AREA_URI = "/api/open/app/area/" + VERSION;
    private static final String INSTANCE_OPEN_URI = "/api/open/app/instance/open/" + VERSION;
    private static final String INSTANCE_RENEW_URI = "/api/open/app/instance/renew/" + VERSION;
    private static final String INSTANCE_RELEASE_URI = "/api/open/app/instance/release/" + VERSION;
    private static final String PROXY_INFO_URI = "/api/open/app/proxy/info/" + VERSION;
    private static final String GET_PRODUCT_AREA_LIST_URI = "/api/open/app/product/area/" + VERSION;
    private static final String ADD_IP_WHITE_LIST_URI = "/api/open/app/proxy/addIpWhiteList/" + VERSION;
    private static final String DEL_IP_WHITE_LIST_URI = "/api/open/app/proxy/delIpWhiteList/" + VERSION;
    private static final String DRAW_BY_API_URI = "/api/open/app/proxy/draw/api/" + VERSION;
    private static final String PROXY_FLOW_USE_LOG_URI = "/api/open/app/proxy/flow/use/log/" + VERSION;
 

    public static final String ENCRYPT_AES = "AES";

    private static String endPoint = "https://api.ipipv.com";
    private static String appKey = "AK20241021180017";
    private static String appSecret = "khjqqk7eytc8otdnteuugccng69y56as";

    public AppInfoResp getAppInfo() throws Exception {
        byte[] res = post(GET_APP_INFO_URI, null);
        AppInfoResp list = JSON.parseObject(new String(res), AppInfoResp.class);
        return list;
    }

    public static List<AppProductSyncResp> getProductStock(AppProductSyncReq req) {
        List<AppProductSyncResp> list = null;
        try {
            byte[] params = JSON.toJSONBytes(req);
            byte[] res = post(GET_PRODUCT_STOCK_URI, params);
            list = JSON.parseArray(new String(res), AppProductSyncResp.class);
        }catch (Exception e){
            log.error("fail to ipipv getProductStock {}", e.getMessage());
        }

        return list;
    }


    public AppCreateUserResp createUser(AppUserReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(CREATE_USER_URI, params);
        AppCreateUserResp resp = JSON.parseObject(new String(res), AppCreateUserResp.class);
        return resp;
    }

    public AppProxyUserResp createProxyUser(AppProxyUserReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(CREATE_PROXY_USER_URI, params);
        AppProxyUserResp resp = JSON.parseObject(new String(res), AppProxyUserResp.class);
        return resp;
    }

    public AppAuthUserResp userAuth(AppAuthUserReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(USER_AUTH_URI, params);
        AppAuthUserResp resp = JSON.parseObject(new String(res), AppAuthUserResp.class);
        return resp;
    }

    public AppDrawByPwdResp drawByPwd(AppDrawByPwdReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(DRAW_BY_PWD_URI, params);
        AppDrawByPwdResp resp = JSON.parseObject(new String(res), AppDrawByPwdResp.class);
        return resp;
    }



    public List<AppInstanceResp> getInstance(AppGetInstanceReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(GET_INSTANCE_URI, params);
        List<AppInstanceResp> list = JSON.parseArray(new String(res), AppInstanceResp.class);
        return list;
    }

    public List<AppAreaResp> getArea(AppGetAreaReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(GET_AREA_URI, params);
        System.out.println(new String(res));
        List<AppAreaResp> list = JSON.parseArray(new String(res), AppAreaResp.class);
        return list;
    }

    /**
     * @Author SN150021
     * @Description //购买ip
     * @Date  2024/10/8 14:24
     **/
    public static AppOrderResp instanceOpen(String orderNo, String owner, int unit, Integer cycleTimes, String productNo) {
        AppOrderResp resp = null;
        try {
            AppInstanceOpenReq req = new AppInstanceOpenReq();
            req.setAppOrderNo(orderNo);
            List<OpenParam> params =new ArrayList<>();
            OpenParam param = new OpenParam();
            //购买数量 （实例个数） 默认 1
            param.setCount(1);
            param.setProductNo(productNo);
            param.setUnit(unit);
            param.setDuration(1);
            param.setCycleTimes(cycleTimes);
            params.add(param);
            req.setParams(params);
            byte[] params1 = JSON.toJSONBytes(req);
            log.info("调用ipv购买实例，入参：owner:{},regionId:{},req:{}", owner, productNo, JSON.toJSONString(req));
            byte[] res = post(INSTANCE_OPEN_URI, params1);
             resp = JSON.parseObject(new String(res), AppOrderResp.class);
            log.info("调用ipv购买实例，响应参数:owner:{},response:{}", owner,
                JSON.toJSON(resp));
        }catch (Exception e){
            log.error("fail to ipipv instanceOpen {}", e.getMessage());
        }

        return resp;
    }

    /**
     * @Author SN150021
     * @Description //查询订单
     * @Date  2024/10/8 14:24
     **/
    public static AppOrderResp getOrder(String orderNo) throws Exception {
        AppGetOrderReq req = new AppGetOrderReq();
        req.setOrderNo(orderNo);
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(GET_ORDER_URI, params);
        AppOrderResp resp = JSON.parseObject(new String(res), AppOrderResp.class);
        return resp;
    }

    /**
     * @author Chen
     * @description 续费
     * @date 2024/10/21 21:02
     */
    public static AppOrderResp instanceRenew(String owner, String orderNo, String instanceNo, int duration) {
        AppOrderResp resp = null;
        try {
            AppInstanceRenewReq req = new AppInstanceRenewReq();
            req.setAppOrderNo(orderNo);
            Instance instance = new Instance();
            instance.setInstanceNo(instanceNo);
            instance.setDuration(duration);
            List<Instance> list = new ArrayList<>();
            list.add(instance);
            req.setInstances(list);
            byte[] params = JSON.toJSONBytes(req);
            log.info("调用ipv续费实例，入参：owner:{},req:{}", owner, JSON.toJSON(req));
            byte[] res = post(INSTANCE_RENEW_URI, params);
            resp = JSON.parseObject(new String(res), AppOrderResp.class);
            log.info("调用ipv续费实例，响应参数：owner:{},req:{}", owner, JSON.toJSON(resp));
        }catch (Exception e){
            log.error("fail to ipipv instanceRenew {}", e.getMessage());
        }
        return resp;
    }
    /**
     * @author Chen
     * @description 释放ip
     * @date 2024/10/21 21:43
     */
    public static AppInstanceReleaseResp instanceRelease(String orderNo, String instanceNo) {
        AppInstanceReleaseResp resp = null;
        try {
            AppInstanceReleaseReq req = new AppInstanceReleaseReq();
            req.setOrderNo(orderNo);
            List<String > list = new ArrayList<>();
            list.add(instanceNo);
            req.setInstances(list);
            byte[] params = JSON.toJSONBytes(req);
            byte[] res = post(INSTANCE_RELEASE_URI, params);
            resp = JSON.parseObject(new String(res), AppInstanceReleaseResp.class);
            log.info("调用Ipv删除ECS实例，响应参数response:{}", JSON.toJSON(resp));
        }catch (Exception e){
            log.error("fail to ipipv instanceRelease {}", e.getMessage());
        }

        return resp;
    }

    public AppProxyInfoResp proxyInfo(AppProxyInfoReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(PROXY_INFO_URI, params);
        AppProxyInfoResp resp = JSON.parseObject(new String(res), AppProxyInfoResp.class);
        return resp;
    }

    public List<AppProductAreaResp> productAreaList(AppProductAreaReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(GET_PRODUCT_AREA_LIST_URI, params);
        List<AppProductAreaResp> list = JSON.parseArray(new String(res), AppProductAreaResp.class);
        return list;
    }

    public AppAddIpWhiteListResp addIpWhiteList(AppAddIpWhiteListReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(ADD_IP_WHITE_LIST_URI, params);
        AppAddIpWhiteListResp resp = JSON.parseObject(new String(res), AppAddIpWhiteListResp.class);
        return resp;
    }

    public AppDelIpWhiteListResp delIpWhiteList(AppDelIpWhiteListReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(DEL_IP_WHITE_LIST_URI, params);
        AppDelIpWhiteListResp resp = JSON.parseObject(new String(res), AppDelIpWhiteListResp.class);
        return resp;
    }

    public AppDrawByApiResp drawByApi(AppDrawByApiReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(DRAW_BY_API_URI, params);
        AppDrawByApiResp resp = JSON.parseObject(new String(res), AppDrawByApiResp.class);
        return resp;
    }

    public AppFlowUseLogResp proxyFlowUseLog(AppFlowUseLogReq req) throws Exception {
        byte[] params = JSON.toJSONBytes(req);
        byte[] res = post(PROXY_FLOW_USE_LOG_URI, params);
        AppFlowUseLogResp resp = JSON.parseObject(new String(res), AppFlowUseLogResp.class);
        return resp;
    }

    private static byte[] post(String uri, byte[] data) throws Exception {
        byte[] resdata = new byte[0];
        //创建httpclient对象
        CloseableHttpClient client = HttpClients.createDefault();
        //创建post方式请求对象
        HttpPost httpPost = new HttpPost(endPoint + uri);
        byte[] iv = appSecret.substring(0, 16).getBytes();
        String msg = "";
        if (data !=null && data.length>0){
            byte[] key = appSecret.getBytes();
            byte[] en = AESCBC.encryptCBC(data, key, iv);
            msg = Base64.getEncoder().encodeToString(en);
        }
        AppOpenReq req = new AppOpenReq("" + System.currentTimeMillis(), "2.0", ENCRYPT_AES, appKey, msg);

        //装填参数
        StringEntity s = new StringEntity(JSON.toJSONString(req), "utf-8");
        s.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE,
                "application/json"));
        //设置参数到请求对象中
        httpPost.setEntity(s);
        System.out.println("请求地址：" + endPoint + uri);
        httpPost.setHeader("Content-type", "application/json");

        //执行请求操作，并拿到结果（同步阻塞）
        CloseableHttpResponse response = client.execute(httpPost);
        //获取结果实体
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String js = EntityUtils.toString(entity, "utf-8");
            //System.out.println(js);
            Res res = JSON.parseObject(js, Res.class);
            if (res.getCode() == 200) {
                byte[] de = Base64.getDecoder().decode(res.getData());
                resdata = AESCBC.decryptCBC(de, appSecret.getBytes(), iv);
            }
            //按指定编码转换结果实体为String类型
        }
        EntityUtils.consume(entity);
        //释放链接
        response.close();
        return resdata;
    }

}


