package com.edgec.browserbackend.common.commons.utils;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtils {

    private static final Logger log = LoggerFactory.getLogger(SmsUtils.class);

    private static final IAcsClient iAcsClient;

    static {
        DefaultProfile profile = DefaultProfile.getProfile("default", "LTAI5tEdz1DY4A4oYUawUuNH", "8KWmYgO0QIicZpyulhEwUhZqStrTwe");
        iAcsClient = new DefaultAcsClient(profile);
    }

    public enum SmsTemplateCode {

        //CLOUDAM_ARREARS("SMS_174805285"),

        //AUTHCODE("SMS_185841618"),
        LOGINACCOUNT(0, "SMS_473465082"),
        NEWACCOUNT(1,"SMS_473435070"),
        RESETACCOUNT(2,"SMS_473480085"),
        IPWILLEXPIRE_EXPIRE(3,"SMS_473405076"),
        IPEXPIRED(4, "SMS_473405076"),
        CLOUDAM_ARREARS(5,"SMS_174805285"),
        //NEWACCOUNT("SMS_187750800")

        ;
        Integer type;


        String code;

        SmsTemplateCode(Integer type, String code) {
            this.type =type;
            this.code = code;
        }

        public Integer getType() {
            return type;
        }


        public String getCode() {
            return code;
        }

        public static SmsTemplateCode getByType(Integer type) {
            for (SmsUtils.SmsTemplateCode smsTemplateCode : SmsUtils.SmsTemplateCode.values()) {
                if (smsTemplateCode.type.intValue() == type.intValue()) {
                    return smsTemplateCode;
                }
            }
            return null;
        }

    }

    public static void sendSms(String phoneNum, SmsTemplateCode smsTemplateCode, JSONObject param) {
        CommonRequest request = new CommonRequest();
        //request.setProtocol(ProtocolType.HTTPS);
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", phoneNum);
        request.putQueryParameter("SignName", "无界超级浏览器");
        request.putQueryParameter("TemplateCode", smsTemplateCode.getCode());
        if(null != param) {
            request.putQueryParameter("TemplateParam", param.toJSONString());
        }
        try {
            CommonResponse response = iAcsClient.getCommonResponse(request);
            if (response.getHttpStatus() == 200 && response.getData().contains("OK")) {
                return;
            } else {
                log.error("Send SMS Error,{}, {}, {}, {}", phoneNum, smsTemplateCode, param, response.getData());
                throw new ClientRequestException(AccountErrorCode.OTHERS, "send sms error, please contact customer" );
            }
        } catch (Exception e) {
            log.error("Send SMS Error,{}, {}, {}", phoneNum, smsTemplateCode, param);
        }
    }


    public static String createRandom(boolean numberFlag, int length) {
        String retStr = "";
        String strTable = numberFlag ? "1234567890" : "1234567890abcdefghijkmnpqrstuvwxyz";
        int len = strTable.length();
        boolean bDone = true;
        do {
            retStr = "";
            int count = 0;
            for (int i = 0; i < length; i++) {
                double dblR = Math.random() * len;
                int intR = (int) Math.floor(dblR);
                char c = strTable.charAt(intR);
                if (('0' <= c) && (c <= '9')) {
                    count++;
                }
                retStr += strTable.charAt(intR);
            }
            if (count >= 2) {
                bDone = false;
            }
        } while (bDone);
        return retStr;
    }

}
