package com.edgec.browserbackend.common.lock;

import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * MongoDB分布式锁Repository
 *
 * @author JMW
 */
@Repository
public class MongoLockRepository {

    private MongoTemplate mongoTemplate;

    public MongoLockRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public List<MongoLock> getByKey(String _id) {
        Query query = new Query();
        query.addCriteria(Criteria.where("_id").is(_id));
        return mongoTemplate.find(query, MongoLock.class);
    }

    /**
     * 指定_id自增increment(原子加),并设置过期时间
     *
     * @param _id 加锁的字段
     * @param increment +1
     * @param expire 生存时间
     * @return 返回查询结果
     */
    public Map<String, Object> incrByWithExpire(String _id, double increment, long expire) {
        //筛选
        Query query = new Query();
        query.addCriteria(new Criteria("_id").is(_id));

        //更新
        Update update = new Update();
        update.inc("value", increment);
        update.set("expire", expire);
        //可选项
        FindAndModifyOptions options = FindAndModifyOptions.options();
        //没有则新增
        options.upsert(true);
        //返回更新后的值
        options.returnNew(true);
        Map<String, Object> resultMap = new HashMap<>(15);
        resultMap.put("value", Double.valueOf((Objects.requireNonNull(mongoTemplate.findAndModify(query, update, options, MongoLock.class))).getValue()).intValue());
        resultMap.put("expire", (Objects.requireNonNull(mongoTemplate.findAndModify(query, update, options, MongoLock.class))).getExpire());
        return resultMap;
    }


    /**
     * 根据value删除过期的内容
     *
     * @param _id 删除的字段
     * @param expireTime 删除的时间限制
     */
    public void removeExpire(String _id, long expireTime) {
        Query query = new Query();
        query.addCriteria(Criteria.where("_id").is(_id));
        query.addCriteria(Criteria.where("expire").lt(expireTime));
        mongoTemplate.remove(query, MongoLock.class);
    }

    public void remove(Map<String, Object> condition) {
        Query query = new Query();
        Set<Map.Entry<String, Object>> set = condition.entrySet();
        int flag = 0;
        for (Map.Entry<String, Object> entry : set) {
            query.addCriteria(Criteria.where(entry.getKey()).is(entry.getValue()));
            flag = flag + 1;
        }
        if (flag == 0) {
            query = null;
        }
        assert query != null;
        mongoTemplate.remove(query, MongoLock.class);
    }

}
