package com.edgec.browserbackend.common.utils;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.common.commons.error.ErrorCode;

import java.util.HashMap;
import java.util.Map;

/**
 * @author JMW
 */
public class ResponseUtil {

    /**成功且带数据**/
    public static ResultDto success(Object object){
        ResultDto result = new ResultDto();
        result.setStatus(0);
        result.setData(object);
        return result;
    }

    /**成功但不带数据**/
    public static ResultDto success(){
        return success(null);
    }

    /**失败**/
    public static ResultDto error(ErrorCode errorCode){
        ResultDto result = new ResultDto();
        result.setStatus(-1);
        Map<String, Object> statusInfo = new HashMap<>(16);
        statusInfo.put("code", errorCode);
        statusInfo.put("message", errorCode.getReason());
        result.setStatusInfo(statusInfo);
        return result;
    }

    /**失败**/
    public static ResultDto error(String message){
        ResultDto result = new ResultDto();
        result.setStatus(-1);
        Map<String, Object> statusInfo = new HashMap<>(16);
        statusInfo.put("code", 80001);
        statusInfo.put("message", message);
        result.setStatusInfo(statusInfo);
        return result;
    }

    /**失败且带数据**/
    public static ResultDto error(Object object){
        ResultDto result = new ResultDto();
        result.setStatus(-1);
        result.setData(object);
        return result;
    }
}
