package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.browser.dto.PageInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

@Repository
public interface AccountRepository extends MongoRepository<Account, String>, AccountRepositoryCustom {

    Account findByName(String name);

    Account findByEmail(String email);

    Account findByPhoneNumber(String phone);

    Account findByPhoneNumberAndParentIsNull(String phone);

    List<Account> findByParent(String parent);

    List<Account> findByParentIsNull();

    Page<Account> findByParent(String parent, Pageable pageable);

    Page<Account> findAllBySignupDateBetween(Pageable pageable, Date startDate, Date endDate);

    List<Account> findAllBySignupDateBetweenAndPromotionCode(Date startDate, Date endDate, String promotionCode);

    Page<Account> findAllBySignupDateBetweenAndPromotionCodeAndParentIsNull(Pageable pageable, Date startDate, Date endDate, String promotionCode);

    Page<Account> findAllBySignupDateBetweenAndParentIsNull(Pageable pageable, Date startDate, Date endDate);

    Page<Account> findAllBySignupDateBetweenAndParentIsNullAndAuthorizedNot(Pageable pageable, Date startDate, Date endDate, int authorized);

    Page<Account> findAll(Pageable pageable);

    List<Account> findByNameIn(List<String> names);

    List<Account> findByPromotionCode(String code);

    int countByPromotionCodeAndParentIsNull(String promotionCode);
}
