package com.edgec.browserbackend.auth.controller;

import com.edgec.browserbackend.auth.domain.UsernameToken;
import com.edgec.browserbackend.auth.service.UsernameTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.List;

@RestController
public class TokenController {

    @Autowired
    private UsernameTokenService usernameTokenService;

    @RequestMapping(path = "/token", method = RequestMethod.GET)
    public List<UsernameToken> selectVpsDtoByParent(Principal principal) {
        return usernameTokenService.selectVpsDtoByParent(principal.getName());
    }

    @RequestMapping(path = "/token", method = RequestMethod.POST)
    public UsernameToken createToken(Principal principal, @RequestParam(value = "username") String username) {
        return usernameTokenService.createUserToken(principal.getName(), username);
    }

}
