package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.dto.*;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ip")
public class IpControlloer {

    @Autowired
    private IpResourceService ipResourceService;

    @RequestMapping(value = "/buy", method = RequestMethod.POST)
    public ResultDto buyIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto){
        ResultDto resultDto = new ResultDto();
        try {
            List<String> ipResourceDto = ipResourceService.buyIp(principal.getName(), ipResourceRequestDto);
            resultDto.setData(ipResourceDto);
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/renew", method = RequestMethod.POST)
    public ResultDto renewIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.renewIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/del", method = RequestMethod.POST)
    public ResultDto deleteIp(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.deleteIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    public ResultDto getIpList(Principal principal, @RequestBody IpListRequestDto ipListRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            IpPageResultDto ipResourceDto = ipResourceService.getIpList(principal.getName(), ipListRequestDto.getGroupType(), ipListRequestDto.getPage(),
                    ipListRequestDto.getAmount(), ipListRequestDto.getFilter());
            resultDto.setData(ipResourceDto);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }


    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultDto updateIp(Principal principal, @RequestBody IpResourceUpdateDto ipResourceUpdateDto) {
        ResultDto resultDto = new ResultDto();
        try {
            ipResourceService.updateIp(principal.getName(), ipResourceUpdateDto);
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/query", method = RequestMethod.POST)
    public ResultDto queryIp(Principal principal, @RequestBody IpResourceUpdateDto ipResourceUpdateDto) {
        ResultDto resultDto = new ResultDto();
        try {
            HashMap<String, Boolean> map = new HashMap<>();
            map.put("found", ipResourceService.queryIpExist(principal.getName(), ipResourceUpdateDto));
            resultDto.setData(map);
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    public ResultDto queryIpDetail(Principal principal, @RequestBody IpResourceRequestDto ipResourceRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            resultDto.setData(ipResourceService.queryIp(principal.getName(), ipResourceRequestDto));
            resultDto.setStatus(0);
        } catch (Exception e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", 80001);
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }
}
