package com.edgec.browserbackend.browser.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IpResourceRequestDto {
    private String name;
    private String region;
    private String regionCn;
    private String vendor="aliyun";
    private String logintype = "password";

    private String shopId;

    //0 -- 余额, 1 -- 支付宝, 2 -- 微信
    private int payMethod = 0;

    @Max(12)
    @Min(1)
    private int period = 1;
    private String unit="month";
    private int amount = 1;
    private boolean autorenew = false;
    private int ipkeptperiod = 7;
    private String startscript = "";

    private String password;
    private String instanceSpecKey;
    private String imageKey;

    private List<String> ports;

    private String system = "linux";

    private List<String> addr = new ArrayList<>();

    private List<String> ipId = new ArrayList<>();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String getImageKey() {
        return imageKey;
    }

    public void setPorts(List<String> ports) {
        this.ports = ports;
    }

    public int getPeriod() {
        return period;
    }

    public void setImageKey(String imageKey) {
        this.imageKey = imageKey;
    }

    public String getUnit() {
        return unit;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getRegion() {
        return region;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public List<String> getPorts() {
        return ports;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegionCn() {
        return regionCn;
    }

    public void setAutorenew(boolean autorenew) {
        this.autorenew = autorenew;
    }

    public int getIpkeptperiod() {
        return ipkeptperiod;
    }

    public List<String> getAddr() {
        return addr;
    }

    public void setAddr(List<String> addr) {
        this.addr = addr;
    }

    public String getInstanceSpecKey() {
        return instanceSpecKey;
    }

    public void setInstanceSpecKey(String instanceSpecKey) {
        this.instanceSpecKey = instanceSpecKey;
    }

    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getSystem() {
        return system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getLogintype() {
        return logintype;
    }

    public void setLogintype(String logintype) {
        this.logintype = logintype;
    }

    public String getStartscript() {
        return startscript;
    }

    public void setStartscript(String startscript) {
        this.startscript = startscript;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIpkeptperiod(int ipkeptperiod) {
        this.ipkeptperiod = ipkeptperiod;
    }

    public void setRegionCn(String regionCn) {
        this.regionCn = regionCn;
    }

    public List<String> getIpId() {
        return ipId;
    }

    public void setIpId(List<String> ipId) {
        this.ipId = ipId;
    }

    public int getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(int payMethod) {
        this.payMethod = payMethod;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }
}
