package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.Account;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

@Repository
public interface AccountRepository extends MongoRepository<Account, String>, AccountRepositoryCustom {

    Account findByName(String name);

    Account findByEmail(String email);

    Account findByPhoneNumber(String phone);

    List<Account> findByParent(String parent);

    Page<Account> findByParentIsNull(Pageable request);

    Page<Account> findAllBySignupDateBetween(Pageable pageable, Date startDate, Date endDate);

    Page<Account> findAll(Pageable pageable);

    List<Account> findByNameIn(List<String> names);
}
