package com.edgec.browserbackend.account.repository;

import com.edgec.browserbackend.account.domain.UserPayment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Repository;

import java.time.ZonedDateTime;
import java.util.List;

@Repository
public interface UserPaymentRepository extends MongoRepository<UserPayment, String>, UserPaymentRepositoryCustom {

    UserPayment findByTradeNo(String tradeNo);

    Page<UserPayment> findByUsernameAndSucceedOrderByPaymentDateDesc(Pageable pageable, String username, boolean isSuccess);

    List<UserPayment> findAllByPaymentDateBetweenAndSucceed(ZonedDateTime start, ZonedDateTime end, boolean isSuccess);

    List<UserPayment> findByUsernameAndSucceedAndTradeNoGreaterThan(String username, boolean succeed, String tradeNo);


}
