package com.edgec.browserbackend.account.service;

import com.edgec.browserbackend.account.domain.*;
import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.account.dto.BillQueryCriteriaDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

public interface AccountService {

    /**
     * Finds account by given name
     *
     * @param accountName
     * @return found account
     */
    Account findByName(String accountName);

    ResultDto getAccountByName(String name);

    /**
     * Checks if account with the same name already exists
     * Invokes Auth Service user creation
     * Creates new account with default parameters
     *
     * @param user
     * @return created account
     */
    Account create(User user);


    Account createWithSms(User user);

    /**
     * Validates and applies incoming account updates
     * Invokes Statistics Service update
     *
     * @param name
     * @param update
     */
    Account saveChanges(String name, Account update);

    void resetPassword(UserDto user);

    Account createSub(String name, AccountDto user);

    void deleteSub(String parent, String child);

    void deleteByName(String name);

    UserDto determUsernameOrEmail(String text);

    Account saveSub(String name, AccountDto user);

    List<UserDto> getAllDesendentUsers(String name, int level);

    List<UserBillList> getUserBills0(String name);

    List<UserBillList> getUserBills(String name, Services services);

    void resetPasswordWithOtp(UserDto user);

    IpChargeResultDto preCharge(String name, IpChargeRequestDto requestDto);

    IpChargeResultDto preChargeByMoney(String name, double money);

    IpChargeResultDto preChargeIp(String name, int amount, double money);

    IpChargeResultDto charge(String name, IpChargeRequestDto requestDto);

    IpChargeResultDto chargeByMoney(String name, double money, IpChargeRequestDto requestDto);

    Page<UserPayment> getUserPayment(Pageable pageable, String username);

    void sendSmsOtp(String phone);

    AccountDto getAccountByCellphone(String cellphone);

    String queryVpsRate(String region, String instanceSpecKey, String chargeType);

    String queryUserChargeRate(String username, IpChargeRequestDto requestDto);

    Page<UserPrePaidBilling> listPrepaid(Pageable pageable, String username, String[] chargeType, int year, int month, int day, String zoneId);

    Page<UserPrePaidBilling> listBills(Pageable pageable, String username, BillQueryCriteriaDto billQueryCriteriaDto, String dateFrom, String dateTo, String zoneId);

    Page<Account> listAccountBySingupDate(Pageable pageable, Date beginDate, Date endDate);

    List<UserBillList> findOverviewByYearAndMonth(String username, int year, int mont, String zoneId, Services service);

    IpChargeResultDto preOrder(String userName, IpChargeRequestDto requestDto);

    String deletePreOrder(String userName);

    List<Invoice> findByUsername(String username);

    boolean writeInvoice(Invoice invoice);

    int invoiceSize(String username);

    void updateUserToken(String username, String token);

}
