package com.edgec.browserbackend.browser.controller;

import com.edgec.browserbackend.account.dto.ResultDto;
import com.edgec.browserbackend.browser.domain.Shop;
import com.edgec.browserbackend.browser.dto.ShopPageResultDto;
import com.edgec.browserbackend.browser.dto.ShopResultDto;
import com.edgec.browserbackend.browser.dto.ShopRequestDto;
import com.edgec.browserbackend.browser.dto.ShopStringResultDto;
import com.edgec.browserbackend.browser.service.ShopService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/shop")
public class ShopController {

    @Autowired
    private ShopService shopService;

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultDto addShop(Principal principal, @RequestBody ShopResultDto shopResultDto) {
        ResultDto resultDto = new ResultDto();
        try {
            ShopStringResultDto shopStringResultDto = new ShopStringResultDto();
            shopStringResultDto.setId(shopService.addShop(principal.getName(), shopResultDto));
            resultDto.setData(shopStringResultDto);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/multiadd", method = RequestMethod.POST)
    public List<String> addShops(Principal principal, @RequestBody List<Shop> shops) {
        return null;
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultDto updateShop(Principal principal, @RequestBody ShopResultDto shopResultDto) {
        ResultDto resultDto = new ResultDto();
        try {
            ShopStringResultDto shopStringResultDto = new ShopStringResultDto();
            shopStringResultDto.setId(shopService.updateShop(principal.getName(), shopResultDto));
            resultDto.setData(shopStringResultDto);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public ResultDto deleteShop(Principal principal, @RequestBody ShopRequestDto shopRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            shopService.deleteShop(principal.getName(), shopRequestDto.getShopId());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/bind", method = RequestMethod.POST)
    public ResultDto bindShop(Principal principal, @RequestBody ShopRequestDto shopRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            shopService.bindShop(principal.getName(), shopRequestDto.getShopId(), shopRequestDto.getIpAddr());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/unbind", method = RequestMethod.POST)
    public ResultDto unBindShop(Principal principal, @RequestBody ShopRequestDto shopRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            shopService.unBindShop(principal.getName(), shopRequestDto.getShopId(), shopRequestDto.getIpAddr());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/transfer", method = RequestMethod.POST)
    public ResultDto transferShop(Principal principal, @RequestBody ShopRequestDto shopRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            shopService.transferShop(principal.getName(), shopRequestDto.getShopId(), shopRequestDto.getToGroup());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/assign", method = RequestMethod.POST)
    public ResultDto assignShop(Principal principal, @RequestBody ShopRequestDto shopRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            shopService.assignShops(principal.getName(), shopRequestDto.getShopIds(), shopRequestDto.getToUsers());
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }

    @RequestMapping(value = "/list",method = RequestMethod.POST)
    public ResultDto getShopList(Principal principal, @RequestBody ShopRequestDto shopRequestDto) {
        ResultDto resultDto = new ResultDto();
        try {
            ShopPageResultDto shopDtos = shopService.getShopList(principal.getName(), shopRequestDto.getGroup(), shopRequestDto.getPage(),
                    shopRequestDto.getAmount(), shopRequestDto.getFilter());
            resultDto.setData(shopDtos);
            resultDto.setStatus(0);
        }catch (ClientRequestException e) {
            resultDto.setStatus(-1);
            Map<String, Object> statusInfo = new HashMap<>();
            statusInfo.put("code", e.getErrorCode());
            statusInfo.put("message", e.getMessage());
            resultDto.setStatusInfo(statusInfo);
        }
        return resultDto;
    }
}
