package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.IpResource;
import com.google.gson.internal.$Gson$Preconditions;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface IpResourceRepository extends MongoRepository<IpResource, String> {
    IpResource findByAddrAndIsDeleted(String addr, boolean isDeleted);
    List<IpResource> findByIdIn(List<String> ipIds);
    List<IpResource> findByOwnerAndShopIdIsNull(String owner);
    List<IpResource> findByOwnerAndStatusAndShopIdIsNull(String owner, int status);
    List<IpResource> findByStatusAndIdIn(int status, List<String> ipIds);
    Page<IpResource> findByAddrLikeAndIdIn(String addr, List<String> ipIds, Pageable pageable);
    Page<IpResource> findByVendorLikeAndIdIn(String vendor, List<String> ipIds, Pageable pageable);
    Page<IpResource> findByRegionLikeAndIdIn(String region, List<String> ipIds, Pageable pageable);
}
