package com.edgec.browserbackend.browser.repository;

import com.edgec.browserbackend.browser.domain.Shop;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

public interface ShopRepository extends MongoRepository<Shop, String> {
    Page<Shop> findByShopIdInAndIpRegionLike(List<String> shopIds, String ipRegion, Pageable pageable);
    Page<Shop> findByShopIdInAndShopAccountLike(List<String> shopIds, String shopAccount, Pageable pageable);
    Page<Shop> findByShopIdInAndShopNameLike(List<String> shopIds, String shopName, Pageable pageable);
    Page<Shop> findByShopIdIn(List<String> shopIds, Pageable pageable);
}
