package com.edgec.browserbackend.browser.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.service.AccountService;
import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.browser.domain.*;
import com.edgec.browserbackend.browser.dto.*;
import com.edgec.browserbackend.browser.repository.*;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.utils.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.time.Instant;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class IpResourceServiceImpl implements IpResourceService {

    private final Logger logger = LoggerFactory.getLogger(IpResourceServiceImpl.class);

    private static String CLOUDAMURL = "https://www.cloudam.cn";
    private static String TESTURL = "http://112.74.13.2";
    private static String USERNAME = "fangguanlianbrowser";

    private static List<String> port = Arrays.asList("20000", "20001");

    private static List<String> protocol = Arrays.asList("socks5", "proxy");

    private static String startscript = "";

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Autowired
    private UserShopRepository userShopRepository;

    @Autowired
    private ShopRepository shopRepository;

    @Autowired
    private AccountService accountService;

    @Autowired
    private IpOptionsRepository ipOptionsRepository;

    @Autowired
    private PlatformOptionsRepository platformOptionsRepository;

    public HttpHeaders buildPostHeader() {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.setBearerAuth("oq5tg3gMsflHcK5iZ2741G5R30XYd9blyOqH9qeBItKtrzfTsGIoy8AsxqqNXdcm");
        return header;
    }

    public HttpHeaders buildGetHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth("oq5tg3gMsflHcK5iZ2741G5R30XYd9blyOqH9qeBItKtrzfTsGIoy8AsxqqNXdcm");
        return headers;
    }

    public static String makeRandomPassword(int len){
        char charr[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@$%^&*.?".toCharArray();
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int x = 0; x < len; ++x) {
            sb.append(charr[r.nextInt(charr.length)]);
        }
        return sb.toString();
    }

    @Override
    public List<IpResourceDto> buyIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        if (account.getPermission() < 8)
            throw new ClientRequestException(AccountErrorCode.NOPERMISSION);
        //todo 预扣费

        List<IpResourceDto> ipResourceDtos = new ArrayList<>();
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders header = buildPostHeader();
        HashMap<String, Object> map = new HashMap<>();
        map.put("name", ipResourceRequestDto.getName());
        map.put("region", ipResourceRequestDto.getRegion());
        map.put("period", String.valueOf(ipResourceRequestDto.getPeriod()));
        map.put("provider", ipResourceRequestDto.getVendor());
        map.put("unit", ipResourceRequestDto.getUnit());
        map.put("amount", String.valueOf(ipResourceRequestDto.getAmount()));
        String password = makeRandomPassword(16);
        map.put("loginPassword", password);
        map.put("startscript", startscript);
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(map, header);
        IpBuyResultDto ipBuyResultDto = null;
        try {
            ipBuyResultDto = restTemplate.postForObject(TESTURL + "/intelligroup/ipresources?accountId=browser", httpEntity, IpBuyResultDto.class);
            if (StringUtils.isNotBlank(ipBuyResultDto.getErrorCode()))
                throw new Exception(ipBuyResultDto.getErrorCode());
        } catch (Throwable e) {
            logger.error("fail to post request", e.getMessage());
            logger.error(e.getMessage());
            throw e;
        }
        try {
            if (ipBuyResultDto != null && ipBuyResultDto.getIplist() != null && ipBuyResultDto.getIplist().size() >= 1) {
                ipBuyResultDto.getIplist().forEach(x -> {
//                    IpInfoResultDto ipInfoResultDto = new IpInfoResultDto();
//                    Map<String, String> params = new HashMap<String, String>();
//                    params.put("accountId", "browser");
//                    params.put("ip", x.getIp());
//                    HttpHeaders headers = buildGetHeader();
//                    HttpEntity<Map<String, String>> entity = new HttpEntity<>(params, headers);
//                    ResponseEntity<String> result = restTemplate.exchange(TESTURL + "/ecc/ipinfo?accountId={accountId}&ip={ip}", HttpMethod.GET, entity, String.class);
//                    JSONObject jsonObject = JSON.parseObject(result.getBody());
//                    if (ipInfoResultDto != null && StringUtils.isBlank(ipInfoResultDto.getErrorCode())) {
                        IpResource ipResource = new IpResource();
                        ipResource.setIpAddr(x.getIp());
                        ipResource.setIpType(IpType.VENDOR);
//                        ipResource.setPurchasedTime(Long.valueOf((String) jsonObject.get("createdWhen")));
//                        ipResource.setValidTime(Long.valueOf((String)jsonObject.get("validTill")));
                        ipResource.setPurchasedTime(Instant.now().toEpochMilli());
                        if (ipResourceRequestDto.getUnit().equals("month"))
                            ipResource.setValidTime(Instant.now().plusSeconds(60*60*24*30).toEpochMilli());
                        else if (ipResourceRequestDto.getUnit().equals("week"))
                            ipResource.setValidTime(Instant.now().plusSeconds(60*60*24*7).toEpochMilli());
                        ipResource.setPort(port);
                        ipResource.setVendor(ipResourceRequestDto.getVendor());
                        ipResource.setStatus(0);
                        ipResource.setUsername(USERNAME);
                        if (account.getParent() != null)
                        ipResource.setUserParent(account.getParent());
                        ipResource.setRegion(ipResourceRequestDto.getRegion());
                        ipResource.setProtocol(protocol);
                        ipResource.setPassword(password);
                        ipResource.setOwner(username);
                        ipResourceRepository.save(ipResource);
                        ipResourceDtos.add(new IpResourceDto(ipResource, null));
//                    }
                });
            }
        } catch (Exception e) {
            logger.error("fail to post request", e.getMessage());
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
        return ipResourceDtos;
    }

    @Override
    public IpOperationResultDto renewIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        ipResourceRequestDto.getAddr().forEach(x -> {
            IpResource ipResource = ipResourceRepository.findByAddrAndIsDeleted(x, false);
            if (ipResource == null)
                throw new ClientRequestException(BrowserErrorCode.IPNOTEXIST);
            if (ipResource.getShopId() != null) {
                UserShop userShop = userShopRepository.findByUsernameAndShopId(username, ipResource.getShopId());
                if (userShop == null)
                    throw new ClientRequestException(AccountErrorCode.NOPERMISSION);
            } else if (!ipResource.getOwner().equals(username)) {
                throw new ClientRequestException(AccountErrorCode.NOPERMISSION);
            }
        });
        //todo 预扣费
        RestTemplate restTemplate = new RestTemplate();
        HashMap<String, Object> map = new HashMap<>();
        map.put("iplist", ipResourceRequestDto.getAddr());
        map.put("period", ipResourceRequestDto.getPeriod());
        HttpHeaders headers = buildPostHeader();
        HttpEntity<Map<String, Object>> entity = new HttpEntity<>(map, headers);
        try {
            ResponseEntity<String> result = restTemplate.exchange(TESTURL + "/intelligroup/renewip?accountId=browser", HttpMethod.PUT, entity, String.class);
            RenewIpResultDto renewIpResultDto = JSON.parseObject(result.getBody(), RenewIpResultDto.class);
            if (StringUtils.isNotBlank(renewIpResultDto.getErrorCode()))
                throw new Exception(renewIpResultDto.getErrorCode());
            IpOperationResultDto ipOperationResultDto = new IpOperationResultDto();
            renewIpResultDto.getIplist().forEach(x -> {
                IpResource ipResource = ipResourceRepository.findByAddrAndIsDeleted(x.getIp(), false);
                ipResource.setValidTime(Instant.parse(x.getValidTill()).toEpochMilli());
                ipResourceRepository.save(ipResource);
                ipOperationResultDto.getSuccessList().add(x.getIp());
            });
            return ipOperationResultDto;
        } catch (Exception e) {
            logger.error("fail to renew ip", e.getMessage());
            logger.error(e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public IpOperationResultDto deleteIp(String username, List<String> ipAddrs) throws Exception {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        IpOperationResultDto ipOperationResultDto = new IpOperationResultDto();
        ipAddrs.forEach(ipAddr -> {
            IpResource ipResource = ipResourceRepository.findByAddrAndIsDeleted(ipAddr, false);
            if (ipResource == null) {
                ipOperationResultDto.getFailList().add(ipAddr);
                return;
            }
            UserShop userShop = null;
            if (ipResource.getShopId() != null) {
                userShop = userShopRepository.findByUsernameAndShopId(username, ipResource.getShopId());
                if (userShop == null) {
                    ipOperationResultDto.getFailList().add(ipAddr);
                    return;
                }
            } else if (!ipResource.getOwner().equals(username)) {
                return;
            }
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = buildGetHeader();
            Map<String, String> params = new HashMap<String, String>();
            HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(params, headers);
            try {
                ResponseEntity<String> result = restTemplate.exchange(TESTURL + "/intelligroup/ipresources?accountId=browser&ip={ip}", HttpMethod.DELETE, httpEntity, String.class, ipAddr);
                DeleteIpResultDto deleteIpResultDto = JSON.parseObject(result.getBody(), DeleteIpResultDto.class);
                if (StringUtils.isNotBlank(deleteIpResultDto.getErrorCode()))
                    throw new Exception(deleteIpResultDto.getErrorCode());
                ipResourceRepository.delete(ipResource);
                if (userShop != null){
                    Shop shop = shopRepository.findById(ipResource.getShopId()).orElse(null);
                    if (shop != null) {
                        shop.setIp(null);
                        shop.setIpId(null);
                        shop.setIpRegion(null);
                        shopRepository.save(shop);
                    }
                    userShop.setIpId(null);
                    userShopRepository.save(userShop);
                }
                ipOperationResultDto.getSuccessList().add(ipAddr);
            } catch (Exception e) {
                logger.error("fail to renew ip", e.getMessage());
                ipOperationResultDto.getFailList().add(ipAddr);
                throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
            }
        });
        return ipOperationResultDto;
    }

    @Override
    public IpPageResultDto getIpList(String username, int groupType, int page, int amount, IpFilterDto ipFilterDto) {
        if (amount > 100)
            amount = 100;
        Pageable pageable = PageRequest.of(page, amount);
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);

        List<String> ipIds = userShopRepository.findByUsername(username).stream().filter(x -> (x.getShopId() != null && x.getIpId() != null))
                .map(x -> x.getIpId()).collect(Collectors.toList());

        List<IpResource> ipResources = new ArrayList<>();
        List<IpResource> notUsed = null;
        switch (groupType) {
            case 1:
                ipResources = ipResourceRepository.findByIdIn(ipIds);;
                notUsed = ipResourceRepository.findByOwnerAndShopIdIsNull(username);
                break;
            case 2:
                ipResources = ipResourceRepository.findByStatusAndIdIn(2, ipIds);
                notUsed = ipResourceRepository.findByOwnerAndStatusAndShopIdIsNull(username, 2);
                break;
            case 3:
                ipResources = ipResourceRepository.findByStatusAndIdIn(1, ipIds);
                notUsed = ipResourceRepository.findByOwnerAndStatusAndShopIdIsNull(username, 1);
                break;
            case 4:
                notUsed = ipResourceRepository.findByOwnerAndShopIdIsNull(username);
                break;
        }
        if (notUsed != null)
            ipResources.addAll(notUsed);
        List<IpResourceDto> ipResourceDtos = new ArrayList<>();
        List<String> allIpIds = ipResources.stream().map(x -> x.getId()).collect(Collectors.toList());
        if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getRegion())) {
            Page<IpResource> ipResources1 = ipResourceRepository.findByRegionLikeAndIdIn(ipFilterDto.getRegion(), allIpIds, pageable);
            ipResources1.getContent().forEach(x -> {
                ShopDto shopDto;
                if (x.getShopId() == null) {
                    shopDto = new ShopDto();
                } else {
                    Shop shop = shopRepository.findById(x.getShopId()).orElse(null);
                    if (shop != null)
                        shopDto = new ShopDto(shop);
                    else
                        shopDto = new ShopDto();
                }
                ipResourceDtos.add(new IpResourceDto(x, shopDto));
            });
        }
        else if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getAddr())) {
            Page<IpResource> ipResources1 = ipResourceRepository.findByAddrLikeAndIdIn(ipFilterDto.getAddr(), allIpIds, pageable);
            ipResources1.getContent().forEach(x -> {
                ShopDto shopDto;
                if (x.getShopId() == null) {
                    shopDto = new ShopDto();
                } else {
                    Shop shop = shopRepository.findById(x.getShopId()).orElse(null);
                    if (shop != null)
                        shopDto = new ShopDto(shop);
                    else
                        shopDto = new ShopDto();
                }
                ipResourceDtos.add(new IpResourceDto(x, shopDto));
            });
        }
        else if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getVendor())) {
            Page<IpResource> ipResources1 = ipResourceRepository.findByVendorLikeAndIdIn(ipFilterDto.getVendor(), allIpIds, pageable);
            ipResources1.getContent().forEach(x -> {
                ShopDto shopDto;
                if (x.getShopId() == null) {
                    shopDto = new ShopDto();
                } else {
                    Shop shop = shopRepository.findById(x.getShopId()).orElse(null);
                    if (shop != null)
                        shopDto = new ShopDto(shop);
                    else
                        shopDto = new ShopDto();
                }
                ipResourceDtos.add(new IpResourceDto(x, shopDto));
            });
        } else  {
            ipResources.forEach(x -> {
                ShopDto shopDto;
                if (x.getShopId() == null) {
                    shopDto = new ShopDto();
                } else {
                    Shop shop = shopRepository.findById(x.getShopId()).orElse(null);
                    if (shop != null)
                        shopDto = new ShopDto(shop);
                    else
                        shopDto = new ShopDto();
                }
                ipResourceDtos.add(new IpResourceDto(x, shopDto));
            });
        }

        Page<IpResourceDto> ipResourceDtoPage = new PageImpl<>(ipResourceDtos, pageable, allIpIds.size());
        IpPageResultDto ipPageResultDto = new IpPageResultDto();
        ipPageResultDto.setIpList(ipResourceDtoPage.getContent());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrentPage(ipResourceDtoPage.getPageable().getPageNumber());
        pageInfo.setTotalPages(ipResourceDtoPage.getTotalPages());
        pageInfo.setTotalItems(allIpIds.size());
        ipPageResultDto.setIpPage(pageInfo);
        return ipPageResultDto;
    }

    @Override
    public void setIpOptions() {
        String path = ClassLoader.getSystemResource("/root/browser/ipOptions.json").getPath();
        IpOptions jsonObject = JSONObject.parseObject(FileUtil.read(new File(path), "UTF-8"), IpOptions.class);
        ipOptionsRepository.save(jsonObject);
    }

    @Override
    public IpOptions getIpOptions() {
        try {
            IpOptions jsonObject = ipOptionsRepository.findAll().get(0);
            return jsonObject;
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public List<PlatformOptions> getPlatformOptions() {
        try {
            List<PlatformOptions> platformOptions = platformOptionsRepository.findAll();
            return platformOptions;
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }
}
