package com.edgec.browserbackend.common.commons.utils;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtils {

    private static final Logger log = LoggerFactory.getLogger(SmsUtils.class);

    private static final IAcsClient iAcsClient;

    static {
        DefaultProfile profile = DefaultProfile.getProfile("default", "LTAIODPWRh6stFca", "0SBDR59HsquSDEj9CFXNt9njTs2cCv");
        iAcsClient = new DefaultAcsClient(profile);
    }

    public enum SmsTemplateCode {

        VPS_INVITE("SMS_171856442"),
        VPS_EXPIRE("SMS_173341111"),
        CLOUDAM_ARREARS("SMS_174805285"),
        CVM_EXPIRE("SMS_175572297"),
        ;


        String code;

        SmsTemplateCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

    }


    public static void notifyNewUserRegistered(String username, String phone, String vps) {
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", "13851961528");
        request.putQueryParameter("SignName", "微艾");
        request.putQueryParameter("TemplateCode", "SMS_170842632");
        request.putQueryParameter("TemplateParam", "{"+"\"name\":\""+username+"\"," +
                "\"number\":\""+phone+"\"," +
                "\"vps\":\""+vps+"\""+
                "}");
        try {
            CommonResponse response = iAcsClient.getCommonResponse(request);
            System.out.println(response);
        } catch (ClientException e) {
            log.error("Sms sends failure",e);
        }

    }


//    public static void sendSmsOpMsg(String username, String groupName, String error) {
//        String randomCode = "";
//        CommonRequest request = new CommonRequest();
//        //request.setProtocol(ProtocolType.HTTPS);
//        request.setMethod(MethodType.POST);
//        request.setDomain("dysmsapi.aliyuncs.com");
//        request.setVersion("2017-05-25");
//        request.setAction("SendSms");
//        request.putQueryParameter("PhoneNumbers", "13851961528");
//        request.putQueryParameter("SignName", "微艾");
//        request.putQueryParameter("TemplateCode", "SMS_166665358");
//        request.putQueryParameter("TemplateParam", "{"+"\"name\":\""+username+"\"," +
//                        "\"group\":\""+groupName+"\"," +
//                        "\"error\":\""+error+"\""+
//                "}");
//        try {
//            CommonResponse response = iAcsClient.getCommonResponse(request);
//            System.out.println(response);
//        } catch (ClientException e) {
//            log.error("Sms sends failure",e);
//        }
//    }


    public static void sendVpsSms(String phoneNum, SmsTemplateCode smsTemplateCode, JSONObject param) {
        CommonRequest request = new CommonRequest();
        //request.setProtocol(ProtocolType.HTTPS);
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", phoneNum);
        request.putQueryParameter("SignName", "防关联VPS");
        request.putQueryParameter("TemplateCode", smsTemplateCode.getCode());
        request.putQueryParameter("TemplateParam", param.toJSONString());
        try {
            CommonResponse response = iAcsClient.getCommonResponse(request);
            if (response.getHttpStatus() == 200 && response.getData().contains("OK")) {
                return;
            } else {
                log.error("Send SMS Error,{}, {}, {}, {}", phoneNum, smsTemplateCode, param, response.getData());
            }
        } catch (Exception e) {
            log.error("Send SMS Error,{}, {}, {}", phoneNum, smsTemplateCode, param);
        }
    }

    public static void sendCloadamSms(String phoneNum, SmsTemplateCode smsTemplateCode, JSONObject param) {
        CommonRequest request = new CommonRequest();
        //request.setProtocol(ProtocolType.HTTPS);
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("PhoneNumbers", phoneNum);
        request.putQueryParameter("SignName", "深圳云端CLOUDAM");
        request.putQueryParameter("TemplateCode", smsTemplateCode.getCode());
        request.putQueryParameter("TemplateParam", param.toJSONString());
        try {
            CommonResponse response = iAcsClient.getCommonResponse(request);
            if (response.getHttpStatus() == 200 && response.getData().contains("OK")) {
                return;
            } else {
                log.error("Send SMS Error,{}, {}, {}, {}", phoneNum, smsTemplateCode, param, response.getData());
            }
        } catch (Exception e) {
            log.error("Send SMS Error,{}, {}, {}", phoneNum, smsTemplateCode, param);
        }
    }


}
