package com.edgec.browserbackend.common.commons.utils;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public class UniquePriorityBlockingQueue<E> extends PriorityBlockingQueue<E> {

    public UniquePriorityBlockingQueue(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public boolean add(E e) {
        if (super.contains(e))
            return true;
        return super.add(e);
    }

    @Override
    public boolean offer(E e) {
        if (super.contains(e))
            return true;
        return super.offer(e);
    }

    @Override
    public void put(E e) {
        if (super.contains(e))
            return;
        super.put(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        if (super.contains(e))
            return true;
        return super.offer(e, timeout, unit);
    }

}
