package com.edgec.browserbackend.browser.domain;

import com.edgec.browserbackend.browser.dto.Interval;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Document(collection = "ipresource")
@JsonIgnoreProperties(ignoreUnknown = true)
public class IpResource implements Serializable {
    @Id
    private String id;
    private String addr;
    private IpType ipType = IpType.VENDOR;
    private Vendor vendor;
    private String vendorCn;
    private String region;
    private String regionCn;
    //0:正常, 1:已过期, 2:即将过期, 3:正在分配, 4:未使用, 5:已失效, 6:未分配, 7:未缴费, 8:分配成功
    private int status;
    private List<String> port;
    private long purchasedTime;
    private long validTime;
    private String details;
    private List<BindHistory> bindHistory = new ArrayList<>();
    private boolean isDeleted;
    private String username;
    private String owner;
    private String userParent;
    private List<String> protocol;
    private String password;
    private double price;

    private boolean specialLine; //是否使用专线
    private boolean usingSpecialLine; //是否正在使用专线
    //专线数据
    private String proxyUsername; //专线的代理用户名
    private String proxyPassword; //专线的代理密码

    private String shopId;
    private String shopName;

    private boolean isLocked;
    private long lockTimestamp;
    private long healthLockTimestamp;

    private String unit;
    private int period;

    public IpResource() {
    }

    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegionCn() {
        return regionCn;
    }

    public void setRegionCn(String regionCn) {
        this.regionCn = regionCn;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public IpType getIpType() {
        return ipType;
    }

    public void setIpType(IpType ipType) {
        this.ipType = ipType;
    }

    public List<BindHistory> getBindHistory() {
        return bindHistory;
    }

    public void setBindHistory(List<BindHistory> bindHistory) {
        this.bindHistory = bindHistory;
    }

    public long getPurchasedTime() {
        return purchasedTime;
    }

    public void setPurchasedTime(long purchasedTime) {
        this.purchasedTime = purchasedTime;
    }

    public long getValidTime() {
        return validTime;
    }

    public void setValidTime(long validTime) {
        this.validTime = validTime;
    }

    public Vendor getVendor() {
        return vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean deleted) {
        isDeleted = deleted;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<String> getPort() {
        return port;
    }

    public void setPort(List<String> port) {
        this.port = port;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public String getUserParent() {
        return userParent;
    }

    public void setUserParent(String userParent) {
        this.userParent = userParent;
    }

    public List<String> getProtocol() {
        return protocol;
    }

    public void setProtocol(List<String> protocol) {
        this.protocol = protocol;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isLocked() {
        return isLocked;
    }

    public void setLocked(boolean locked) {
        isLocked = locked;
    }

    public long getLockTimestamp() {
        return lockTimestamp;
    }

    public void setLockTimestamp(long lockTimestamp) {
        this.lockTimestamp = lockTimestamp;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public int getPeriod() {
        return period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getVendorCn() {
        return vendorCn;
    }

    public void setVendorCn(String vendorCn) {
        this.vendorCn = vendorCn;
    }

    public String getProxyPassword() {
        return proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyUsername() {
        return proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public boolean isSpecialLine() {
        return specialLine;
    }

    public void setSpecialLine(boolean specialLine) {
        this.specialLine = specialLine;
    }

    public long getHealthLockTimestamp() {
        return healthLockTimestamp;
    }

    public void setHealthLockTimestamp(long healthLockTimestamp) {
        this.healthLockTimestamp = healthLockTimestamp;
    }

    public boolean isUsingSpecialLine() {
        return usingSpecialLine;
    }

    public void setUsingSpecialLine(boolean usingSpecialLine) {
        this.usingSpecialLine = usingSpecialLine;
    }
}
