package com.edgec.browserbackend.browser.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.edgec.browserbackend.account.domain.Account;
import com.edgec.browserbackend.account.domain.IpChargeRequestDto;
import com.edgec.browserbackend.account.domain.IpChargeResultDto;
import com.edgec.browserbackend.account.exception.AccountErrorCode;
import com.edgec.browserbackend.account.repository.AccountRepository;
import com.edgec.browserbackend.account.service.AccountService;
import com.edgec.browserbackend.browser.ErrorCode.BrowserErrorCode;
import com.edgec.browserbackend.browser.domain.*;
import com.edgec.browserbackend.browser.dto.*;
import com.edgec.browserbackend.browser.repository.*;
import com.edgec.browserbackend.browser.service.IpAndShopService;
import com.edgec.browserbackend.browser.service.IpResourceService;
import com.edgec.browserbackend.browser.service.ShopService;
import com.edgec.browserbackend.common.commons.error.ClientRequestException;
import com.edgec.browserbackend.common.commons.utils.NotifyUtils;
import com.edgec.browserbackend.common.utils.FileUtil;
import com.edgec.browserbackend.common.utils.PollerUtils;
import com.edgec.browserbackend.common.utils.ThreadPoolUtils;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Service
public class IpResourceServiceImpl implements IpResourceService {

    private final Logger logger = LoggerFactory.getLogger(IpResourceServiceImpl.class);

    private static String CLOUDAMURL = "https://www.cloudam.cn";
    private static String TESTURL = "http://112.74.13.2";
    private static String USERNAME = "fangguanlianbrowser";

    public static List<String> region = Arrays.asList(
            "asiapa",
            "hongkong",
            "japan",
            "s-korea",
            "us",
            "malaysia",
            "yajiada",
            "singapore",
            "australia",
            "germany",
            "uk",
            "brazil",
            "moscow",
            "canada",
            "france",
            "sweden",
            "s-korea",
            "india",
            "meast",
            "brazil",
            "virginia",
            "ohio",
            "california",
            "oregon",
            "ireland",
            "london",
            "ireland");

    private static List<String> port = Arrays.asList("20000", "20001");

    private static List<String> protocol = Arrays.asList("socks5", "proxy");

    @Value("${spring.profiles.active}")
    private String profiles;

    @Autowired
    private AccountRepository accountRepository;

    @Autowired
    private IpResourceRepository ipResourceRepository;

    @Autowired
    private UserShopRepository userShopRepository;

    @Autowired
    private ShopRepository shopRepository;

    @Autowired
    private AccountService accountService;

    @Autowired
    private IpOptionsRepository ipOptionsRepository;

    @Autowired
    private PlatformOptionsRepository platformOptionsRepository;

    @Autowired
    private IpAndShopService ipAndShopService;

    @Autowired
    private SpecialLineRepository specialLineRepository;

    public HttpHeaders buildPostHeader() {
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        if (profiles.equals("dev"))
            header.setBearerAuth("oq5tg3gMsflHcK5iZ2741G5R30XYd9blyOqH9qeBItKtrzfTsGIoy8AsxqqNXdcm");
        else if (profiles.equals("prod"))
            header.setBearerAuth("tKWsuHzcngf0RQPMss70f9jgymDIwgQ9zbLfESJdcou3pZSNWl7lNTzto8VQgwaO");
        return header;
    }

    public HttpHeaders buildGetHeader() {
        HttpHeaders headers = new HttpHeaders();
        if (profiles.equals("dev"))
            headers.setBearerAuth("oq5tg3gMsflHcK5iZ2741G5R30XYd9blyOqH9qeBItKtrzfTsGIoy8AsxqqNXdcm");
        else if (profiles.equals("prod"))
            headers.setBearerAuth("tKWsuHzcngf0RQPMss70f9jgymDIwgQ9zbLfESJdcou3pZSNWl7lNTzto8VQgwaO");
        return headers;
    }

    public static String genRandom(int srcFlag, int length) {
        String retStr = "";
        String strTable = "";
        switch (srcFlag) {
            case 1:
                strTable = "1234567890";
                break;
            case 2:
                strTable = "1234567890abcdefghijklmnopqrstuvwxyz";
                break;
            case 3:
                strTable = "12345678901234567890abcdefghijkmnpqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            case 4:
                strTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            case 5:
                strTable = "abcdefghijklmnopqrstuvwxyz";
                break;
            default:
                strTable = "1234567890abcdefghijkmnpqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
        }

        int len = strTable.length() - 3;
        boolean bDone = true;
        do {
            retStr = "";
            int count = 0;
            for (int i = 0; i < length; i++) {
                double dblR = Math.random() * len;
                int intR = (int) Math.floor(dblR);
                char c = strTable.charAt(intR);
                if (('0' <= c) && (c <= '9')) {
                    count++;
                }
                retStr += strTable.charAt(intR);
            }
            if (count >= 2) {
                bDone = false;
            }
        } while (bDone);
        retStr += "a";
        retStr += "A";
        retStr += "1";
        return retStr;
    }

    private IpChargeRequestDto buildIpChargeRequestDto(IpResourceRequestDto request, int chargeType, int payMethod) {
        IpChargeRequestDto ipChargeRequestDto = new IpChargeRequestDto();
        ipChargeRequestDto.setAmount(request.getAmount());
        ipChargeRequestDto.setChargeType(chargeType);
        ipChargeRequestDto.setRegion(request.getRegion());
        ipChargeRequestDto.setPeriod(request.getPeriod());
        ipChargeRequestDto.setUnit(request.getUnit());
        ipChargeRequestDto.setPayMethod(payMethod);
        return ipChargeRequestDto;
    }

    @Override
    public List<String> buyIp(String username, IpResourceRequestDto ipResourceRequestDto) throws Exception {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        if (account.getPermission() < 4)
            throw new ClientRequestException(AccountErrorCode.NOPERMISSION);

        Map<String, List<String>> priceList = ipOptionsRepository.findAll().get(0).getIpPlatForm();
        if (ipResourceRequestDto.getRegion() == null)
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        if (ipResourceRequestDto.getRegionCn() == null)
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        double newprice = 0;
        if (!ipResourceRequestDto.getVendor().equals("own")) {
            List<String> vendorPrices = priceList.get(ipResourceRequestDto.getRegionCn());
            String price = vendorPrices.stream()
                    .filter(x ->  Vendor.valueOf(ipResourceRequestDto.getVendor()).getValue().equals(x.substring(0, x.indexOf("-"))))
                    .map(x -> x.substring(x.lastIndexOf("-") + 1)).collect(Collectors.joining());
            newprice = ipResourceRequestDto.getUnit().equals("week") ? (Integer.valueOf(price)/3) : Integer.valueOf(price);
        }

        IpChargeResultDto ipChargeResultDto = accountService.preChargeByMoney(username, newprice * ipResourceRequestDto.getAmount() * ipResourceRequestDto.getPeriod());
        if (!ipChargeResultDto.isSuccess()) {
            throw new ClientRequestException(AccountErrorCode.NOTENOUGHBALANCE);
        }

        String password;
        if (StringUtils.isNotBlank(ipResourceRequestDto.getPassword()))
            password = ipResourceRequestDto.getPassword();
        else
            password = genRandom(3, 12);

        List<IpResourceDto> ipResourceDtos = new ArrayList<>();
        List<String> ipIds = new ArrayList<>();

        for (int i = 0; i < ipResourceRequestDto.getAmount(); i++) {
            IpResource ipResource = new IpResource();
            ipResource.setPeriod(ipResourceRequestDto.getPeriod());
            //充6送1
            if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 6)
                ipResource.setPeriod(7);
            else if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 12)
                ipResource.setPeriod(14);

            if (ipResourceRequestDto.getVendor().equals("local")) {
                ipResource.setAddr("本地Ip未使用");
                ipResource.setIpType(IpType.LOCAL);
                ipResource.setVendor(Vendor.valueOf(ipResourceRequestDto.getVendor()));
                ipResource.setVendorCn("本地");
                ipResource.setStatus(4);
                ipResource.setUsername(USERNAME);
                if (ipResourceRequestDto.getUnit().equals("week"))
                    ipResource.setValidTime(Instant.now().atZone(ZoneOffset.UTC).plusWeeks(ipResource.getPeriod()).toInstant().toEpochMilli());
                else
                    ipResource.setValidTime(Instant.now().atZone(ZoneOffset.UTC).plusMonths(ipResource.getPeriod()).toInstant().toEpochMilli());
                ipResource.setPort(port);
            } else if (ipResourceRequestDto.getVendor().equals("own")) {
                if (ipResourceRequestDto.getAddr() == null || ipResourceRequestDto.getAddr().size() == 0)
                    throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
                if (StringUtils.isBlank(ipResourceRequestDto.getAddr().get(i)))
                    throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
                ipResource.setSpecialLine(ipResourceRequestDto.isSpecialLine());
                ipResource.setAddr(ipResourceRequestDto.getAddr().get(i));
                ipResource.setIpType(IpType.OWN);
                ipResource.setVendor(Vendor.valueOf(ipResourceRequestDto.getVendor()));
                ipResource.setVendorCn("自有");
                ipResource.setStatus(4);
                ipResource.setUsername(ipResourceRequestDto.getUsername());
                ipResource.setValidTime(Instant.now().atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
                ipResource.setPort(ipResourceRequestDto.getPorts());
            } else {
                ipResource.setAddr("");
                ipResource.setIpType(IpType.VENDOR);
                ipResource.setVendor(Vendor.valueOf(ipResourceRequestDto.getVendor()));
                switch (ipResourceRequestDto.getVendor()) {
                    case "aliyun":
                        ipResource.setVendorCn("阿里云");
                        break;
                    case "tencent":
                        ipResource.setVendorCn("腾讯云");
                        break;
                    case "aws":
                        ipResource.setVendorCn("亚马逊云");
                        break;
                }
                ipResource.setStatus(6);
                if (ipResourceRequestDto.getUnit().equals("week"))
                    ipResource.setValidTime(Instant.now().atZone(ZoneOffset.UTC).plusWeeks(ipResource.getPeriod()).toInstant().toEpochMilli());
                else
                    ipResource.setValidTime(Instant.now().atZone(ZoneOffset.UTC).plusMonths(ipResource.getPeriod()).toInstant().toEpochMilli());
                ipResource.setUsername(USERNAME);
                ipResource.setPort(port);
            }
            ipResource.setPurchasedTime(Instant.now().toEpochMilli());

            if (account.getParent() != null)
                ipResource.setUserParent(account.getParent());
            ipResource.setRegion(ipResourceRequestDto.getRegion());
            if ((StringUtils.isNotBlank(ipResource.getRegion()) && region.contains(ipResource.getRegion())) || (ipResourceRequestDto.getVendor().equals("own") && ipResource.isSpecialLine())) {
                ipResource.setProxyUsername(ipResource.getAddr());
                ipResource.setProxyPassword(genRandom(3, 12));
                ipResource.setSpecialLine(true);
                ipResource.setHealthLockTimestamp(Instant.now().minusSeconds(60*20).toEpochMilli());
            }
            ipResource.setRegionCn(ipResourceRequestDto.getRegionCn());
            ipResource.setProtocol(protocol);
            ipResource.setPassword(password);
            ipResource.setOwner(username);
            ipResource.setLocked(false);
            ipResource.setLockTimestamp(Instant.now().toEpochMilli());
            ipResource.setUnit(ipResourceRequestDto.getUnit());
            ipResource.setPrice(newprice);
            IpResource ipResource1 = ipResourceRepository.save(ipResource);
            ipResourceDtos.add(new IpResourceDto(ipResource1, null, false));
            ipIds.add(ipResource1.getId());
        }

        if (!ipResourceRequestDto.getVendor().equals("own")) {
            IpChargeRequestDto ipChargeRequestDto = buildIpChargeRequestDto(ipResourceRequestDto, 1, ipResourceRequestDto.getPayMethod());
            accountService.chargeByMoney(username, newprice * ipChargeRequestDto.getAmount() * ipChargeRequestDto.getPeriod(), ipChargeRequestDto);
        }

        if (ipResourceRequestDto.getShopId() != null) {
            ShopRequestDto shopRequestDto = new ShopRequestDto();
            shopRequestDto.setIpId(ipResourceDtos.get(0).getId());
            shopRequestDto.setShopId(ipResourceRequestDto.getShopId());
            ipAndShopService.bindShop(username, shopRequestDto);
        }

        return ipIds;
    }

    @Override
    public IpOperationResultDto renewIp(String username, IpResourceRequestDto ipResourceRequestDto) {
        String URL = (profiles.equals("dev") || profiles.equals("staging"))? TESTURL : CLOUDAMURL;
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);

        List<String> failedList = ipResourceRequestDto.getAddr();

        Map<String, List<String>> priceList = ipOptionsRepository.findAll().get(0).getIpPlatForm();

        AtomicReference<Double> totalprice = new AtomicReference<>((double) 0);
        ipResourceRequestDto.getAddr().stream().map(x -> ipResourceRepository.findByAddrAndIsDeleted(x, false))
                .forEach(ipResource -> {
                    List<String> prices;
                    if (!ipResourceRequestDto.getVendor().equals("own"))
                        prices = priceList.get(ipResource.getRegionCn());
                    else {
                        if (ipResource.isSpecialLine())
                            prices = priceList.get("自有专线");
                        else
                            prices = priceList.get("自有");
                    }
                    for(String vendorprice:prices) {
                        if (ipResource.getVendor().getValue().equals(vendorprice.substring(0, vendorprice.indexOf("-"))))
                            totalprice.updateAndGet(v -> new Double( v + Double.valueOf(vendorprice.substring(vendorprice.lastIndexOf("-") + 1))));
                    } });

        double newprice = ipResourceRequestDto.getUnit().equals("week") ? (int) (totalprice.get()/3) : totalprice.get().intValue();
        IpChargeResultDto ipChargeResultDto = accountService.preChargeByMoney(username, newprice * ipResourceRequestDto.getPeriod() * ipResourceRequestDto.getAmount());
        if (!ipChargeResultDto.isSuccess()) {
            throw new ClientRequestException(AccountErrorCode.NOTENOUGHBALANCE);
        }

        IpOperationResultDto ipOperationResultDto = new IpOperationResultDto();

        int period = 0;
        period = ipResourceRequestDto.getPeriod();
        //充6送1
        if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 6)
            period = 7;
        else if (ipResourceRequestDto.getUnit().equals("month") && ipResourceRequestDto.getPeriod() == 12)
            period = 14;

        if (ipResourceRequestDto.getAddr() != null && ipResourceRequestDto.getAddr().size() > 0) {
            RestTemplate restTemplate = new RestTemplate();
            HashMap<String, Object> map = new HashMap<>();
            map.put("iplist", ipResourceRequestDto.getAddr());
            map.put("period", period);
            map.put("unit", ipResourceRequestDto.getUnit());
            HttpHeaders headers = buildPostHeader();
            HttpEntity<Map<String, Object>> entity = new HttpEntity<>(map, headers);
            ResponseEntity<String> result = restTemplate.exchange(URL + "/intelligroup/renewip?accountId=browser", HttpMethod.PUT, entity, String.class);
            RenewIpResultDto renewIpResultDto = JSON.parseObject(result.getBody(), RenewIpResultDto.class);
            if (StringUtils.isNotBlank(renewIpResultDto.getErrorCode())) {
                logger.error(renewIpResultDto.getErrorCode());
                throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
            }

            renewIpResultDto.getIplist().forEach(x -> {
                IpResource ipResource = ipResourceRepository.findByAddrAndIsDeleted(x.getIp(), false);
                List<String> vendorPrices = priceList.get(ipResource.getRegionCn());
                String price = vendorPrices.stream()
                        .filter(vendorprice -> ipResource.getVendor().getValue().equals(vendorprice.substring(0, vendorprice.indexOf("-"))))
                        .map(vendorprice -> vendorprice.substring(vendorprice.lastIndexOf("-") + 1)).collect(Collectors.joining());

                double newprice1 = ipResourceRequestDto.getUnit().equals("week") ? (Integer.valueOf(price)/3) : Integer.valueOf(price);
                IpChargeRequestDto ipChargeRequestDto = buildIpChargeRequestDto(ipResourceRequestDto, 2, ipResourceRequestDto.getPayMethod());
                accountService.chargeByMoney(username, newprice1 * ipResourceRequestDto.getPeriod() * ipResourceRequestDto.getAmount(), ipChargeRequestDto);

                ipResource.setValidTime(Instant.parse(x.getValidTill()).toEpochMilli());
                ipResourceRepository.save(ipResource);
                ipOperationResultDto.getSuccessList().add(x.getIp());

                failedList.remove(x.getIp());
            });

            ipOperationResultDto.setFailList(failedList);
        }
        if (ipResourceRequestDto.getIpId() != null && ipResourceRequestDto.getIpId().size() > 0) {
            int finalPeriod = period;
            ipResourceRequestDto.getIpId().forEach(x -> {
                IpResource ipResource = ipResourceRepository.findByIdAndIsDeleted(x, false);
                List<String> vendorPrices;
                if (!ipResourceRequestDto.getVendor().equals("own"))
                    vendorPrices = priceList.get(ipResource.getRegionCn());
                else {
                    if (ipResource.isSpecialLine())
                        vendorPrices = priceList.get("自有专线");
                    else
                        vendorPrices = priceList.get("自有");
                }

                String price = vendorPrices.stream()
                        .filter(vendorprice -> ipResource.getVendor().getValue().equals(vendorprice.substring(0, vendorprice.indexOf("-"))))
                        .map(vendorprice -> vendorprice.substring(vendorprice.lastIndexOf("-") + 1)).collect(Collectors.joining());

                double newprice1 = ipResourceRequestDto.getUnit().equals("week") ? (Integer.valueOf(price) / 3) : Integer.valueOf(price);
                IpChargeRequestDto ipChargeRequestDto = buildIpChargeRequestDto(ipResourceRequestDto, 2, ipResourceRequestDto.getPayMethod());
                accountService.chargeByMoney(username, newprice1 * ipResourceRequestDto.getPeriod() * ipResourceRequestDto.getAmount(), ipChargeRequestDto);

                if (ipResourceRequestDto.getUnit().equals("week")) {
                    ipResource.setValidTime(Instant.ofEpochMilli(ipResource.getValidTime()).atZone(ZoneOffset.UTC)
                            .plusWeeks(finalPeriod).toInstant().toEpochMilli());
                } else {
                    ipResource.setValidTime(Instant.ofEpochMilli(ipResource.getValidTime()).atZone(ZoneOffset.UTC)
                            .plusMonths(finalPeriod).toInstant().toEpochMilli());
                }
                ipResourceRepository.save(ipResource);
                ipOperationResultDto.getSuccessList().add(x);

                failedList.remove(x);
            });
        }

        return ipOperationResultDto;
    }

    @Override
    public IpOperationResultDto deleteIp(String username, IpResourceRequestDto ipResourceRequestDto) {
        String URL = (profiles.equals("dev") || profiles.equals("staging"))? TESTURL : CLOUDAMURL;
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        IpOperationResultDto ipOperationResultDto = new IpOperationResultDto();
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = buildGetHeader();
        Map<String, String> params = new HashMap<String, String>();
        HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(params, headers);

        if (ipResourceRequestDto.getAddr() != null && ipResourceRequestDto.getAddr().size() > 0) {
            ipResourceRequestDto.getAddr().forEach(ipAddr -> {
                IpResource ipResource = ipResourceRepository.findByAddrAndIsDeletedAndIsLocked(ipAddr, false, false);
                if (ipResource == null) {
                    ipOperationResultDto.getFailList().add(ipAddr);
                    return;
                }
                UserShop userShop = null;

                if (ipResource.getShopId() != null) {
                    Shop shop = shopRepository.findById(ipResource.getShopId()).orElse(null);
                    if (shop != null) {
                        userShop = userShopRepository.findByUsernameAndShopId(username, shop.getShopId());
                        if (userShop == null) {
                            ipOperationResultDto.getFailList().add(ipAddr);
                            return;
                        }
                    } else if (!ipResource.getOwner().equals(username)) {
                        ipOperationResultDto.getFailList().add(ipAddr);
                        return;
                    }
                }
                try {
                    ResponseEntity<String> result = restTemplate.exchange(URL + "/intelligroup/ipresources?accountId=browser&ip={ip}", HttpMethod.DELETE, httpEntity, String.class, ipAddr);
                    DeleteIpResultDto deleteIpResultDto = JSON.parseObject(result.getBody(), DeleteIpResultDto.class);
                    if (deleteIpResultDto.getResult().equals("failed") || StringUtils.isNotBlank(deleteIpResultDto.getErrorCode())) {
                        NotifyUtils.sendMessage("防关联浏览器 ip " + ipResource.getAddr() + " 删除失败", NotifyUtils.MsgType.WEBHOOK);
                        logger.error("ip " + ipResource.getAddr() + " 删除失败");
                    }
                    if (ipResource.getStatus() == 6)
                        ipResourceRepository.delete(ipResource);
                    else {
                        ipResource.setShopId(null);
                        ipResource.setShopName(null);
                        ipResource.setDeleted(true);
                        ipResourceRepository.save(ipResource);
                    }
                    ipOperationResultDto.getSuccessList().add(ipAddr);
                } catch (Exception e) {
                    logger.error("fail to delete ip", e.getMessage());
                    ipOperationResultDto.getFailList().add(ipAddr);
                    return;
                }
            });
        }
        if (ipResourceRequestDto.getIpId() != null && ipResourceRequestDto.getIpId().size() > 0) {
            ipResourceRequestDto.getIpId().forEach(ipId -> {
                IpResource ipResource = ipResourceRepository.findByIdAndIsDeletedAndIsLocked(ipId, false, false);
                if (ipResource == null) {
                    ipOperationResultDto.getFailList().add(ipId);
                    return;
                }
                if (ipResource.getStatus() == 6)
                    ipResourceRepository.delete(ipResource);
                else if (StringUtils.isNotBlank(ipResource.getAddr()) && ipResource.getIpType() == IpType.VENDOR) {
                    ResponseEntity<String> result = restTemplate.exchange(URL + "/intelligroup/ipresources?accountId=browser&ip={ip}",
                            HttpMethod.DELETE, httpEntity, String.class, ipResource.getAddr());
                    DeleteIpResultDto deleteIpResultDto = JSON.parseObject(result.getBody(), DeleteIpResultDto.class);
                    if (deleteIpResultDto.getResult().equals("failed") || StringUtils.isNotBlank(deleteIpResultDto.getErrorCode())) {
                        NotifyUtils.sendMessage("防关联浏览器 ip " + ipResource.getAddr() + " 删除失败", NotifyUtils.MsgType.WEBHOOK);
                        logger.error("ip " + ipResource.getAddr() + " 删除失败");
                    }
                }
                UserShop userShop = null;
                if (ipResource.getShopId() != null) {
                    Shop shop = shopRepository.findById(ipResource.getShopId()).orElse(null);
                    if (shop != null) {
                        userShop = userShopRepository.findByUsernameAndShopId(username, shop.getShopId());
                        if (userShop == null) {
                            ipOperationResultDto.getFailList().add(ipId);
                            return;
                        }
                    } else if (!ipResource.getOwner().equals(username)) {
                        ipOperationResultDto.getFailList().add(ipId);
                        return;
                    }
                }
                ipResource.setDeleted(true);
                ipResource.setShopId(null);
                ipResource.setShopName(null);
                ipResourceRepository.save(ipResource);
                ipOperationResultDto.getSuccessList().add(ipId);
            });
        }

        return ipOperationResultDto;
    }

    @Override
    public IpPageResultDto getIpList(String username, int groupType, int page, int amount, IpFilterDto ipFilterDto) {
        if (amount > 100)
            amount = 100;
        Pageable pageable = PageRequest.of(page, amount);
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);

        List<String> shopIds = userShopRepository.findByUsername(username).stream().map(x -> x.getShopId()).collect(Collectors.toList());

        List<IpResource> ipResources = new ArrayList<>();
        List<IpResource> notUsed = null;
        List<String> children = new ArrayList<>();
        boolean isParent = false;
        if (account.getParent() == null) {
            isParent = true;
            children = accountRepository.findByParent(account.getName()).stream().map(Account::getName).collect(Collectors.toList());
        }

        children.add(account.getName());

        switch (groupType) {
            case 1:
                ipResources = ipResourceRepository.findByShopIdInAndIsDeleted(shopIds, false);
                if (!isParent)
                    notUsed = ipResourceRepository.findByOwnerAndIsDeletedAndShopIdIsNull(username, false);
                else
                    notUsed = ipResourceRepository.findByOwnerInAndIsDeletedAndShopIdIsNull(children, false);
                break;
            case 2:
                ipResources = ipResourceRepository.findByStatusAndShopIdInAndIsDeleted(2, shopIds, false);
                if (!isParent)
                    notUsed = ipResourceRepository.findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(username, 2, false);
                else
                    notUsed = ipResourceRepository.findByOwnerInAndStatusAndIsDeletedAndShopIdIsNull(children, 2, false);
                break;
            case 3:
                ipResources = ipResourceRepository.findByStatusAndShopIdInAndIsDeleted(1, shopIds, false);
                if (!isParent)
                    notUsed = ipResourceRepository.findByOwnerAndStatusAndIsDeletedAndShopIdIsNull(username, 1, false);
                else
                    notUsed = ipResourceRepository.findByOwnerInAndStatusAndIsDeletedAndShopIdIsNull(children, 1, false);
                break;
            case 4:
                if (!isParent)
                    notUsed = ipResourceRepository.findByOwnerAndStatusIsNotInAndIsDeletedAndShopIdIsNull(username, Arrays.asList(3, 5, 6),false);
                else
                    notUsed = ipResourceRepository.findByOwnerInAndStatusIsNotInAndIsDeletedAndShopIdIsNull(children, Arrays.asList(3, 5, 6), false);
                break;
        }
        if (notUsed != null)
            ipResources.addAll(notUsed);
        List<IpResourceDto> ipResourceDtos = new ArrayList<>();
        List<String> allIpIds = ipResources.stream().map(x -> x.getId()).collect(Collectors.toList());
        Page<IpResource> ipResources1 = null;
        if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getRegion())) {
            ipResources1 = ipResourceRepository.findByIsDeletedAndIdInAndRegionCnLikeOrderByPurchasedTimeDesc(false, allIpIds, ipFilterDto.getRegion(), pageable);
        }
        else if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getAddr())) {
            ipResources1 = ipResourceRepository.findByIsDeletedAndIdInAndAddrLikeOrderByPurchasedTimeDesc(false, allIpIds, ipFilterDto.getAddr(), pageable);
        }
        else if (ipFilterDto != null && StringUtils.isNotBlank(ipFilterDto.getVendor())) {
            ipResources1 = ipResourceRepository.findByIsDeletedAndIdInAndVendorCnLikeOrderByPurchasedTimeDesc(false, allIpIds, ipFilterDto.getVendor(), pageable);
        } else  {
            ipResources1 = ipResourceRepository.findByIdInAndIsDeletedOrderByPurchasedTimeDesc(allIpIds, false, pageable);
        }
        if (ipResources1 != null) {
            ipResources1.getContent().forEach(x -> {
                ShopDto shopDto;
                Shop shop = null;
                if (x.getShopId() != null)
                    shop = shopRepository.findById(x.getShopId()).orElse(null);
                if (shop == null) {
                    shopDto = new ShopDto();
                } else {
                    shopDto = new ShopDto(shop);
                }
                if (StringUtils.isNotBlank(x.getAddr())) {
                    if (x.getLockTimestamp() >= Instant.now().minusSeconds(120).toEpochMilli() && x.getIpType() == IpType.VENDOR && (x.getStatus() == 0 || x.getStatus() == 2)) {
                        x.setStatus(3);
                    }
                    else if (x.getValidTime() <= Instant.now().plusSeconds(60*60*24*7).toEpochMilli() && x.getValidTime() >Instant.now().toEpochMilli()) {
                        if (x.getStatus() != 5 && x.getStatus() != 3 && x.getStatus() != 6) {
                            x.setStatus(2);
                            ipResourceRepository.save(x);
                        }
                    }
                    else if (x.getValidTime() <= Instant.now().minusSeconds(60*60*24*7).toEpochMilli() && x.getStatus() != 3 && x.getStatus() != 6) {
                        if (x.getIpType() == IpType.VENDOR) {
                            IpResourceRequestDto ipResourceRequestDto = new IpResourceRequestDto();
                            ipResourceRequestDto.setAddr(Arrays.asList(x.getAddr()));
                            deleteIp(username, ipResourceRequestDto);
                        } else {
                            IpResourceRequestDto ipResourceRequestDto = new IpResourceRequestDto();
                            ipResourceRequestDto.setIpId(Arrays.asList(x.getId()));
                            deleteIp(username, ipResourceRequestDto);
                        }
                        return;
                    }
                    else if (x.getValidTime() <= Instant.now().toEpochMilli() && x.getStatus() != 3 && x.getStatus() != 6) {
                        x.setStatus(1);
                        ipResourceRepository.save(x);
                    }
                    else {
                        if ((x.getStatus() == 0 || x.getStatus() == 1 || x.getStatus() == 2) && !x.getVendor().equals(Vendor.local)) {
                            x.setStatus(0);
                            ipResourceRepository.save(x);
                        } else if (x.getIpType().equals(IpType.LOCAL) && (x.getStatus() == 1 || x.getStatus() == 2) && x.getAddr().equals("本地Ip未使用") ) {
                            x.setStatus(4);
                            ipResourceRepository.save(x);
                        }
                    }
                }
                if (x.getStatus() == 6 || (x.isSpecialLine() && x.getPurchasedTime() > (Instant.now().toEpochMilli() - 12*60*1000)))
                    x.setStatus(3);
                if (x.getStatus() == 3) {
                    x.setAddr("");
                }
                SpecialLine specialLine = specialLineRepository.findAll().get(0);
                if (x.isSpecialLine())
                    ipResourceDtos.add(new IpResourceDto(x, shopDto, false, specialLine));
                else
                    ipResourceDtos.add(new IpResourceDto(x, shopDto, false));
            });
        }

        Page<IpResourceDto> ipResourceDtoPage = new PageImpl<>(ipResourceDtos, pageable, allIpIds.size());
        IpPageResultDto ipPageResultDto = new IpPageResultDto();
        ipPageResultDto.setIpList(ipResourceDtoPage.getContent());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrentPage(ipResourceDtoPage.getPageable().getPageNumber());
        pageInfo.setTotalPages(ipResourceDtoPage.getTotalPages());
        pageInfo.setTotalItems(allIpIds.size());
        ipPageResultDto.setIpPage(pageInfo);
        return ipPageResultDto;
    }

    @Override
    public void setIpOptions() {
        String path = ClassLoader.getSystemResource("ipOptions.json").getPath();
        IpOptions jsonObject = JSONObject.parseObject(FileUtil.read(new File(path), "UTF-8"), IpOptions.class);
        ipOptionsRepository.save(jsonObject);
    }

    @Override
    public IpOptions getIpOptions() {
        try {
            IpOptions jsonObject = ipOptionsRepository.findAll().get(0);
            return jsonObject;
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public List<PlatformOptions> getPlatformOptions() {
        try {
            List<PlatformOptions> platformOptions = platformOptionsRepository.findAll();
            return platformOptions;
        } catch (Exception e) {
            logger.error(e.getMessage());
            throw new ClientRequestException(BrowserErrorCode.UNKNOWN);
        }
    }

    @Override
    public IpSummary getIpSummary(String username) {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        IpSummary ipSummary = new IpSummary();
        List<String> shopIds = userShopRepository.findByUsername(username).stream().map(x -> x.getShopId()).collect(Collectors.toList());
        List<String> used = ipResourceRepository.findByShopIdInAndIsDeleted(shopIds,false).stream().map(x -> x.getId()).collect(Collectors.toList());
        List<String> unbind = ipResourceRepository.findByOwnerAndIsDeletedAndShopIdIsNull(username, false).stream().map(x -> x.getId()).collect(Collectors.toList());
        ipSummary.setUnbind(unbind.size());
        unbind.addAll(used);
        int expired = ipResourceRepository.countByStatusAndIdInAndIsDeleted(1, unbind, false);
        ipSummary.setExpired(expired);
        int willexpired = ipResourceRepository.countByStatusAndIdInAndIsDeleted(2, unbind, false);
        ipSummary.setWillExpire(willexpired);
        ipSummary.setTotal(unbind.size());
        return ipSummary;
    }

    @Override
    public void updateIp(String username, IpResourceUpdateDto ipResourceUpdateDto) {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        if (account.getPermission() < 8)
            throw new ClientRequestException(AccountErrorCode.NOPERMISSION);
        IpResource ipResource = ipResourceRepository.findByIdAndIsDeleted(ipResourceUpdateDto.getIpId(), false);
        if (ipResource == null)
            throw new ClientRequestException(BrowserErrorCode.IPNOTEXIST);
        if (StringUtils.isNotBlank(ipResourceUpdateDto.getAddr())) {
            ipResource.setAddr(ipResourceUpdateDto.getAddr());
        }
        if (StringUtils.isNotBlank(ipResource.getRegion()) && region.contains(ipResource.getRegion())) {
            ipResource.setProxyUsername(ipResource.getAddr());
            ipResource.setProxyPassword(genRandom(3, 12));
            ipResource.setSpecialLine(true);
        }
        ipResource.setStatus(ipResourceUpdateDto.getStatus());
        ipResourceRepository.save(ipResource);
    }

    @Override
    public boolean queryIpExist(String username, IpResourceUpdateDto ipResourceUpdateDto) {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        IpResource ipResource = ipResourceRepository.findByAddrAndIsDeleted(ipResourceUpdateDto.getAddr(), false);
        if (ipResource != null) {
            return true;
        }
        return false;
    }

    @Override
    public IpResourceDto queryIp(String username, IpResourceRequestDto ipResourceRequestDto) {
        Account account = accountRepository.findByName(username);
        if (account == null)
            throw new ClientRequestException(AccountErrorCode.NAMENOTEXIST);
        IpResource ipResource = null;
        if (ipResourceRequestDto.getAddr() != null && ipResourceRequestDto.getAddr().size() > 0)
            ipResource = ipResourceRepository.findByAddrAndIsDeleted(ipResourceRequestDto.getAddr().get(0), false);
        else if (ipResourceRequestDto.getIpId() != null && ipResourceRequestDto.getIpId().size() > 0)
            ipResource = ipResourceRepository.findByIdAndIsDeleted(ipResourceRequestDto.getIpId().get(0), false);
        else {
            throw new ClientRequestException(BrowserErrorCode.INFORMATIONNOTCOMPELETE);
        }

        if (ipResource == null)
            throw new ClientRequestException(BrowserErrorCode.IPNOTEXIST);

        ShopDto shopDto;
        Shop shop = null;
        if (ipResource.getShopId() != null)
            shop = shopRepository.findById(ipResource.getShopId()).orElse(null);
        if (shop == null) {
            shopDto = new ShopDto();
        } else {
            shopDto = new ShopDto(shop);
        }
        if (StringUtils.isNotBlank(ipResource.getAddr())) {
            if (ipResource.getValidTime() <= Instant.now().plusSeconds(60 * 60 * 24 * 7).toEpochMilli() && ipResource.getValidTime() > Instant.now().toEpochMilli()) {
                ipResource.setStatus(2);
                ipResourceRepository.save(ipResource);
            } else if (ipResource.getValidTime() <= Instant.now().minusSeconds(60 * 60 * 24 * 7).toEpochMilli()) {
                deleteIp(username, ipResourceRequestDto);
            } else if (ipResource.getValidTime() <= Instant.now().toEpochMilli()) {
                ipResource.setStatus(1);
                ipResourceRepository.save(ipResource);
            } else {
                if (ipResource.getStatus() != 4 && ipResource.getStatus() != 5) {
                    ipResource.setStatus(0);
                    ipResourceRepository.save(ipResource);
                }
            }
        }
        IpResourceDto ipResourceDto = new IpResourceDto(ipResource, shopDto, true);

        return ipResourceDto;
    }

    @Override
    public void setSpecialLine() {
        List<IpResource> ipResources = ipResourceRepository.findByRegionInAndIsDeleted(region, false);
        for (IpResource ipResource : ipResources) {
            ipResource.setProxyUsername(ipResource.getAddr());
            ipResource.setProxyPassword(genRandom(3, 12));
            ipResource.setSpecialLine(true);
            ipResourceRepository.save(ipResource);
        }
    }

    @Override
    public void releaseDeletedIp() {
        String URL = (profiles.equals("dev") || profiles.equals("staging"))? TESTURL : CLOUDAMURL;
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = buildGetHeader();
        Map<String, String> params = new HashMap<String, String>();
        HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(params, headers);
        List<IpResource> ipResources = ipResourceRepository.findByIsDeleted(true);
        ipResources.forEach(x -> {
            ResponseEntity<String> result = restTemplate.exchange(URL + "/intelligroup/ipresources?accountId=browser&ip={ip}", HttpMethod.DELETE, httpEntity, String.class, x.getAddr());
            DeleteIpResultDto deleteIpResultDto = JSON.parseObject(result.getBody(), DeleteIpResultDto.class);
        });
    }
}
